<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpCustomerRaw StructType
 * @subpackage Structs
 */
class AxpCustomerRaw extends AbstractStructBase
{
    /**
     * The cust_id
     * @var int
     */
    public $cust_id;
    /**
     * The cust_no
     * @var string
     */
    public $cust_no;
    /**
     * The company
     * @var string
     */
    public $company;
    /**
     * The addr1
     * @var string
     */
    public $addr1;
    /**
     * The addr2
     * @var string
     */
    public $addr2;
    /**
     * The zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The company_no
     * @var string
     */
    public $company_no;
    /**
     * The employees
     * @var int
     */
    public $employees;
    /**
     * The phone
     * @var string
     */
    public $phone;
    /**
     * The phone2
     * @var string
     */
    public $phone2;
    /**
     * The fax
     * @var string
     */
    public $fax;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The homepage
     * @var string
     */
    public $homepage;
    /**
     * The company_p_no
     * @var string
     */
    public $company_p_no;
    /**
     * The company_form
     * @var string
     */
    public $company_form;
    /**
     * The active
     * @var int
     */
    public $active;
    /**
     * The discount
     * @var int
     */
    public $discount;
    /**
     * The rating
     * @var int
     */
    public $rating;
    /**
     * The area
     * @var int
     */
    public $area;
    /**
     * The consultant
     * @var int
     */
    public $consultant;
    /**
     * The notes
     * @var string
     */
    public $notes;
    /**
     * The cafeteria
     * @var string
     */
    public $cafeteria;
    /**
     * The other_agencies
     * @var string
     */
    public $other_agencies;
    /**
     * The ctime
     * @var string
     */
    public $ctime;
    /**
     * The busy_months
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:int[]
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $busy_months;
    /**
     * The transport_info
     * @var string
     */
    public $transport_info;
    /**
     * The cust_group
     * @var int
     */
    public $cust_group;
    /**
     * The field_of_work
     * @var int
     */
    public $field_of_work;
    /**
     * The erp_segment
     * @var int
     */
    public $erp_segment;
    /**
     * The old_order_hours
     * @var float
     */
    public $old_order_hours;
    /**
     * The secondary_consultant
     * @var int
     */
    public $secondary_consultant;
    /**
     * The third_consultant
     * @var int
     */
    public $third_consultant;
    /**
     * The efaktura_ean
     * @var string
     */
    public $efaktura_ean;
    /**
     * The efaktura_account
     * @var string
     */
    public $efaktura_account;
    /**
     * The payment_attention
     * @var string
     */
    public $payment_attention;
    /**
     * The payment_addr1
     * @var string
     */
    public $payment_addr1;
    /**
     * The payment_addr2
     * @var string
     */
    public $payment_addr2;
    /**
     * The payment_zip
     * @var string
     */
    public $payment_zip;
    /**
     * The payment_city
     * @var string
     */
    public $payment_city;
    /**
     * The payment_country
     * @var string
     */
    public $payment_country;
    /**
     * The payment_customer
     * @var int
     */
    public $payment_customer;
    /**
     * The erp_inc_stamdata
     * @var int
     */
    public $erp_inc_stamdata;
    /**
     * The no_confirm_timesheet
     * @var int
     */
    public $no_confirm_timesheet;
    /**
     * The default_order_ref
     * @var string
     */
    public $default_order_ref;
    /**
     * The flags
     * @var int
     */
    public $flags;
    /**
     * The missing_order_ref_notice
     * @var string
     */
    public $missing_order_ref_notice;
    /**
     * The new_order_note_popup
     * @var bool
     */
    public $new_order_note_popup;
    /**
     * The diverse_code_1
     * @var int
     */
    public $diverse_code_1;
    /**
     * The diverse_code_2
     * @var int
     */
    public $diverse_code_2;
    /**
     * The diverse_code_3
     * @var int
     */
    public $diverse_code_3;
    /**
     * The import_tag
     * @var string
     */
    public $import_tag;
    /**
     * The fixed_ordernumber
     * @var string
     */
    public $fixed_ordernumber;
    /**
     * The order_notebar
     * @var string
     */
    public $order_notebar;
    /**
     * The partners_agreement_end
     * @var int
     */
    public $partners_agreement_end;
    /**
     * The timesheet_receipt_receivers
     * @var string
     */
    public $timesheet_receipt_receivers;
    /**
     * The notebar
     * @var string
     */
    public $notebar;
    /**
     * The order_temp_limit
     * @var int
     */
    public $order_temp_limit;
    /**
     * The stampclock
     * @var int
     */
    public $stampclock;
    /**
     * The invoice_email
     * @var string
     */
    public $invoice_email;
    /**
     * The baids
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:int[]
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $baids;
    /**
     * The guest_data
     * Meta informations extracted from the WSDL
     * - arrayType: tns:AxpGuestfieldData[]
     * - ref: SOAP-ENC:arrayType
     * @var \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData[]
     */
    public $guest_data;
    /**
     * The dids
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:int[]
     * - ref: SOAP-ENC:arrayType
     * @var int[]
     */
    public $dids;
    /**
     * The homepage2
     * @var string
     */
    public $homepage2;
    /**
     * Constructor method for AxpCustomerRaw
     * @uses AxpCustomerRaw::setCust_id()
     * @uses AxpCustomerRaw::setCust_no()
     * @uses AxpCustomerRaw::setCompany()
     * @uses AxpCustomerRaw::setAddr1()
     * @uses AxpCustomerRaw::setAddr2()
     * @uses AxpCustomerRaw::setZip()
     * @uses AxpCustomerRaw::setCity()
     * @uses AxpCustomerRaw::setCountry()
     * @uses AxpCustomerRaw::setCompany_no()
     * @uses AxpCustomerRaw::setEmployees()
     * @uses AxpCustomerRaw::setPhone()
     * @uses AxpCustomerRaw::setPhone2()
     * @uses AxpCustomerRaw::setFax()
     * @uses AxpCustomerRaw::setEmail()
     * @uses AxpCustomerRaw::setHomepage()
     * @uses AxpCustomerRaw::setCompany_p_no()
     * @uses AxpCustomerRaw::setCompany_form()
     * @uses AxpCustomerRaw::setActive()
     * @uses AxpCustomerRaw::setDiscount()
     * @uses AxpCustomerRaw::setRating()
     * @uses AxpCustomerRaw::setArea()
     * @uses AxpCustomerRaw::setConsultant()
     * @uses AxpCustomerRaw::setNotes()
     * @uses AxpCustomerRaw::setCafeteria()
     * @uses AxpCustomerRaw::setOther_agencies()
     * @uses AxpCustomerRaw::setCtime()
     * @uses AxpCustomerRaw::setBusy_months()
     * @uses AxpCustomerRaw::setTransport_info()
     * @uses AxpCustomerRaw::setCust_group()
     * @uses AxpCustomerRaw::setField_of_work()
     * @uses AxpCustomerRaw::setErp_segment()
     * @uses AxpCustomerRaw::setOld_order_hours()
     * @uses AxpCustomerRaw::setSecondary_consultant()
     * @uses AxpCustomerRaw::setThird_consultant()
     * @uses AxpCustomerRaw::setEfaktura_ean()
     * @uses AxpCustomerRaw::setEfaktura_account()
     * @uses AxpCustomerRaw::setPayment_attention()
     * @uses AxpCustomerRaw::setPayment_addr1()
     * @uses AxpCustomerRaw::setPayment_addr2()
     * @uses AxpCustomerRaw::setPayment_zip()
     * @uses AxpCustomerRaw::setPayment_city()
     * @uses AxpCustomerRaw::setPayment_country()
     * @uses AxpCustomerRaw::setPayment_customer()
     * @uses AxpCustomerRaw::setErp_inc_stamdata()
     * @uses AxpCustomerRaw::setNo_confirm_timesheet()
     * @uses AxpCustomerRaw::setDefault_order_ref()
     * @uses AxpCustomerRaw::setFlags()
     * @uses AxpCustomerRaw::setMissing_order_ref_notice()
     * @uses AxpCustomerRaw::setNew_order_note_popup()
     * @uses AxpCustomerRaw::setDiverse_code_1()
     * @uses AxpCustomerRaw::setDiverse_code_2()
     * @uses AxpCustomerRaw::setDiverse_code_3()
     * @uses AxpCustomerRaw::setImport_tag()
     * @uses AxpCustomerRaw::setFixed_ordernumber()
     * @uses AxpCustomerRaw::setOrder_notebar()
     * @uses AxpCustomerRaw::setPartners_agreement_end()
     * @uses AxpCustomerRaw::setTimesheet_receipt_receivers()
     * @uses AxpCustomerRaw::setNotebar()
     * @uses AxpCustomerRaw::setOrder_temp_limit()
     * @uses AxpCustomerRaw::setStampclock()
     * @uses AxpCustomerRaw::setInvoice_email()
     * @uses AxpCustomerRaw::setBaids()
     * @uses AxpCustomerRaw::setGuest_data()
     * @uses AxpCustomerRaw::setDids()
     * @uses AxpCustomerRaw::setHomepage2()
     * @param int $cust_id
     * @param string $cust_no
     * @param string $company
     * @param string $addr1
     * @param string $addr2
     * @param string $zip
     * @param string $city
     * @param string $country
     * @param string $company_no
     * @param int $employees
     * @param string $phone
     * @param string $phone2
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param string $company_p_no
     * @param string $company_form
     * @param int $active
     * @param int $discount
     * @param int $rating
     * @param int $area
     * @param int $consultant
     * @param string $notes
     * @param string $cafeteria
     * @param string $other_agencies
     * @param string $ctime
     * @param int[] $busy_months
     * @param string $transport_info
     * @param int $cust_group
     * @param int $field_of_work
     * @param int $erp_segment
     * @param float $old_order_hours
     * @param int $secondary_consultant
     * @param int $third_consultant
     * @param string $efaktura_ean
     * @param string $efaktura_account
     * @param string $payment_attention
     * @param string $payment_addr1
     * @param string $payment_addr2
     * @param string $payment_zip
     * @param string $payment_city
     * @param string $payment_country
     * @param int $payment_customer
     * @param int $erp_inc_stamdata
     * @param int $no_confirm_timesheet
     * @param string $default_order_ref
     * @param int $flags
     * @param string $missing_order_ref_notice
     * @param bool $new_order_note_popup
     * @param int $diverse_code_1
     * @param int $diverse_code_2
     * @param int $diverse_code_3
     * @param string $import_tag
     * @param string $fixed_ordernumber
     * @param string $order_notebar
     * @param int $partners_agreement_end
     * @param string $timesheet_receipt_receivers
     * @param string $notebar
     * @param int $order_temp_limit
     * @param int $stampclock
     * @param string $invoice_email
     * @param int[] $baids
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData[] $guest_data
     * @param int[] $dids
     * @param string $homepage2
     */
    public function __construct($cust_id = null, $cust_no = null, $company = null, $addr1 = null, $addr2 = null, $zip = null, $city = null, $country = null, $company_no = null, $employees = null, $phone = null, $phone2 = null, $fax = null, $email = null, $homepage = null, $company_p_no = null, $company_form = null, $active = null, $discount = null, $rating = null, $area = null, $consultant = null, $notes = null, $cafeteria = null, $other_agencies = null, $ctime = null, array $busy_months = array(), $transport_info = null, $cust_group = null, $field_of_work = null, $erp_segment = null, $old_order_hours = null, $secondary_consultant = null, $third_consultant = null, $efaktura_ean = null, $efaktura_account = null, $payment_attention = null, $payment_addr1 = null, $payment_addr2 = null, $payment_zip = null, $payment_city = null, $payment_country = null, $payment_customer = null, $erp_inc_stamdata = null, $no_confirm_timesheet = null, $default_order_ref = null, $flags = null, $missing_order_ref_notice = null, $new_order_note_popup = null, $diverse_code_1 = null, $diverse_code_2 = null, $diverse_code_3 = null, $import_tag = null, $fixed_ordernumber = null, $order_notebar = null, $partners_agreement_end = null, $timesheet_receipt_receivers = null, $notebar = null, $order_temp_limit = null, $stampclock = null, $invoice_email = null, array $baids = array(), array $guest_data = array(), array $dids = array(), $homepage2 = null)
    {
        $this
            ->setCust_id($cust_id)
            ->setCust_no($cust_no)
            ->setCompany($company)
            ->setAddr1($addr1)
            ->setAddr2($addr2)
            ->setZip($zip)
            ->setCity($city)
            ->setCountry($country)
            ->setCompany_no($company_no)
            ->setEmployees($employees)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setFax($fax)
            ->setEmail($email)
            ->setHomepage($homepage)
            ->setCompany_p_no($company_p_no)
            ->setCompany_form($company_form)
            ->setActive($active)
            ->setDiscount($discount)
            ->setRating($rating)
            ->setArea($area)
            ->setConsultant($consultant)
            ->setNotes($notes)
            ->setCafeteria($cafeteria)
            ->setOther_agencies($other_agencies)
            ->setCtime($ctime)
            ->setBusy_months($busy_months)
            ->setTransport_info($transport_info)
            ->setCust_group($cust_group)
            ->setField_of_work($field_of_work)
            ->setErp_segment($erp_segment)
            ->setOld_order_hours($old_order_hours)
            ->setSecondary_consultant($secondary_consultant)
            ->setThird_consultant($third_consultant)
            ->setEfaktura_ean($efaktura_ean)
            ->setEfaktura_account($efaktura_account)
            ->setPayment_attention($payment_attention)
            ->setPayment_addr1($payment_addr1)
            ->setPayment_addr2($payment_addr2)
            ->setPayment_zip($payment_zip)
            ->setPayment_city($payment_city)
            ->setPayment_country($payment_country)
            ->setPayment_customer($payment_customer)
            ->setErp_inc_stamdata($erp_inc_stamdata)
            ->setNo_confirm_timesheet($no_confirm_timesheet)
            ->setDefault_order_ref($default_order_ref)
            ->setFlags($flags)
            ->setMissing_order_ref_notice($missing_order_ref_notice)
            ->setNew_order_note_popup($new_order_note_popup)
            ->setDiverse_code_1($diverse_code_1)
            ->setDiverse_code_2($diverse_code_2)
            ->setDiverse_code_3($diverse_code_3)
            ->setImport_tag($import_tag)
            ->setFixed_ordernumber($fixed_ordernumber)
            ->setOrder_notebar($order_notebar)
            ->setPartners_agreement_end($partners_agreement_end)
            ->setTimesheet_receipt_receivers($timesheet_receipt_receivers)
            ->setNotebar($notebar)
            ->setOrder_temp_limit($order_temp_limit)
            ->setStampclock($stampclock)
            ->setInvoice_email($invoice_email)
            ->setBaids($baids)
            ->setGuest_data($guest_data)
            ->setDids($dids)
            ->setHomepage2($homepage2);
    }
    /**
     * Get cust_id value
     * @return int|null
     */
    public function getCust_id()
    {
        return $this->cust_id;
    }
    /**
     * Set cust_id value
     * @param int $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCust_id($cust_id = null)
    {
        // validation for constraint: int
        if (!is_null($cust_id) && !is_numeric($cust_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_id)), __LINE__);
        }
        $this->cust_id = $cust_id;
        return $this;
    }
    /**
     * Get cust_no value
     * @return string|null
     */
    public function getCust_no()
    {
        return $this->cust_no;
    }
    /**
     * Set cust_no value
     * @param string $cust_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCust_no($cust_no = null)
    {
        // validation for constraint: string
        if (!is_null($cust_no) && !is_string($cust_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cust_no)), __LINE__);
        }
        $this->cust_no = $cust_no;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get addr1 value
     * @return string|null
     */
    public function getAddr1()
    {
        return $this->addr1;
    }
    /**
     * Set addr1 value
     * @param string $addr1
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setAddr1($addr1 = null)
    {
        // validation for constraint: string
        if (!is_null($addr1) && !is_string($addr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr1)), __LINE__);
        }
        $this->addr1 = $addr1;
        return $this;
    }
    /**
     * Get addr2 value
     * @return string|null
     */
    public function getAddr2()
    {
        return $this->addr2;
    }
    /**
     * Set addr2 value
     * @param string $addr2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setAddr2($addr2 = null)
    {
        // validation for constraint: string
        if (!is_null($addr2) && !is_string($addr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr2)), __LINE__);
        }
        $this->addr2 = $addr2;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get company_no value
     * @return string|null
     */
    public function getCompany_no()
    {
        return $this->company_no;
    }
    /**
     * Set company_no value
     * @param string $company_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCompany_no($company_no = null)
    {
        // validation for constraint: string
        if (!is_null($company_no) && !is_string($company_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company_no)), __LINE__);
        }
        $this->company_no = $company_no;
        return $this;
    }
    /**
     * Get employees value
     * @return int|null
     */
    public function getEmployees()
    {
        return $this->employees;
    }
    /**
     * Set employees value
     * @param int $employees
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setEmployees($employees = null)
    {
        // validation for constraint: int
        if (!is_null($employees) && !is_numeric($employees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($employees)), __LINE__);
        }
        $this->employees = $employees;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get homepage value
     * @return string|null
     */
    public function getHomepage()
    {
        return $this->homepage;
    }
    /**
     * Set homepage value
     * @param string $homepage
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setHomepage($homepage = null)
    {
        // validation for constraint: string
        if (!is_null($homepage) && !is_string($homepage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homepage)), __LINE__);
        }
        $this->homepage = $homepage;
        return $this;
    }
    /**
     * Get company_p_no value
     * @return string|null
     */
    public function getCompany_p_no()
    {
        return $this->company_p_no;
    }
    /**
     * Set company_p_no value
     * @param string $company_p_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCompany_p_no($company_p_no = null)
    {
        // validation for constraint: string
        if (!is_null($company_p_no) && !is_string($company_p_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company_p_no)), __LINE__);
        }
        $this->company_p_no = $company_p_no;
        return $this;
    }
    /**
     * Get company_form value
     * @return string|null
     */
    public function getCompany_form()
    {
        return $this->company_form;
    }
    /**
     * Set company_form value
     * @param string $company_form
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCompany_form($company_form = null)
    {
        // validation for constraint: string
        if (!is_null($company_form) && !is_string($company_form)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company_form)), __LINE__);
        }
        $this->company_form = $company_form;
        return $this;
    }
    /**
     * Get active value
     * @return int|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param int $active
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setActive($active = null)
    {
        // validation for constraint: int
        if (!is_null($active) && !is_numeric($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get discount value
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param int $discount
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: int
        if (!is_null($discount) && !is_numeric($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get rating value
     * @return int|null
     */
    public function getRating()
    {
        return $this->rating;
    }
    /**
     * Set rating value
     * @param int $rating
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setRating($rating = null)
    {
        // validation for constraint: int
        if (!is_null($rating) && !is_numeric($rating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rating)), __LINE__);
        }
        $this->rating = $rating;
        return $this;
    }
    /**
     * Get area value
     * @return int|null
     */
    public function getArea()
    {
        return $this->area;
    }
    /**
     * Set area value
     * @param int $area
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setArea($area = null)
    {
        // validation for constraint: int
        if (!is_null($area) && !is_numeric($area)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($area)), __LINE__);
        }
        $this->area = $area;
        return $this;
    }
    /**
     * Get consultant value
     * @return int|null
     */
    public function getConsultant()
    {
        return $this->consultant;
    }
    /**
     * Set consultant value
     * @param int $consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setConsultant($consultant = null)
    {
        // validation for constraint: int
        if (!is_null($consultant) && !is_numeric($consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($consultant)), __LINE__);
        }
        $this->consultant = $consultant;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get cafeteria value
     * @return string|null
     */
    public function getCafeteria()
    {
        return $this->cafeteria;
    }
    /**
     * Set cafeteria value
     * @param string $cafeteria
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCafeteria($cafeteria = null)
    {
        // validation for constraint: string
        if (!is_null($cafeteria) && !is_string($cafeteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cafeteria)), __LINE__);
        }
        $this->cafeteria = $cafeteria;
        return $this;
    }
    /**
     * Get other_agencies value
     * @return string|null
     */
    public function getOther_agencies()
    {
        return $this->other_agencies;
    }
    /**
     * Set other_agencies value
     * @param string $other_agencies
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setOther_agencies($other_agencies = null)
    {
        // validation for constraint: string
        if (!is_null($other_agencies) && !is_string($other_agencies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($other_agencies)), __LINE__);
        }
        $this->other_agencies = $other_agencies;
        return $this;
    }
    /**
     * Get ctime value
     * @return string|null
     */
    public function getCtime()
    {
        return $this->ctime;
    }
    /**
     * Set ctime value
     * @param string $ctime
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCtime($ctime = null)
    {
        // validation for constraint: string
        if (!is_null($ctime) && !is_string($ctime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ctime)), __LINE__);
        }
        $this->ctime = $ctime;
        return $this;
    }
    /**
     * Get busy_months value
     * @return int[]|null
     */
    public function getBusy_months()
    {
        return $this->busy_months;
    }
    /**
     * Set busy_months value
     * @throws \InvalidArgumentException
     * @param int[] $busy_months
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setBusy_months(array $busy_months = array())
    {
        foreach ($busy_months as $axpCustomerRawBusy_monthsItem) {
            // validation for constraint: itemType
            if (!is_numeric($axpCustomerRawBusy_monthsItem)) {
                throw new \InvalidArgumentException(sprintf('The busy_months property can only contain items of int, "%s" given', is_object($axpCustomerRawBusy_monthsItem) ? get_class($axpCustomerRawBusy_monthsItem) : gettype($axpCustomerRawBusy_monthsItem)), __LINE__);
            }
        }
        $this->busy_months = $busy_months;
        return $this;
    }
    /**
     * Add item to busy_months value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function addToBusy_months($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The busy_months property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->busy_months[] = $item;
        return $this;
    }
    /**
     * Get transport_info value
     * @return string|null
     */
    public function getTransport_info()
    {
        return $this->transport_info;
    }
    /**
     * Set transport_info value
     * @param string $transport_info
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setTransport_info($transport_info = null)
    {
        // validation for constraint: string
        if (!is_null($transport_info) && !is_string($transport_info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transport_info)), __LINE__);
        }
        $this->transport_info = $transport_info;
        return $this;
    }
    /**
     * Get cust_group value
     * @return int|null
     */
    public function getCust_group()
    {
        return $this->cust_group;
    }
    /**
     * Set cust_group value
     * @param int $cust_group
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setCust_group($cust_group = null)
    {
        // validation for constraint: int
        if (!is_null($cust_group) && !is_numeric($cust_group)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_group)), __LINE__);
        }
        $this->cust_group = $cust_group;
        return $this;
    }
    /**
     * Get field_of_work value
     * @return int|null
     */
    public function getField_of_work()
    {
        return $this->field_of_work;
    }
    /**
     * Set field_of_work value
     * @param int $field_of_work
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setField_of_work($field_of_work = null)
    {
        // validation for constraint: int
        if (!is_null($field_of_work) && !is_numeric($field_of_work)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($field_of_work)), __LINE__);
        }
        $this->field_of_work = $field_of_work;
        return $this;
    }
    /**
     * Get erp_segment value
     * @return int|null
     */
    public function getErp_segment()
    {
        return $this->erp_segment;
    }
    /**
     * Set erp_segment value
     * @param int $erp_segment
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setErp_segment($erp_segment = null)
    {
        // validation for constraint: int
        if (!is_null($erp_segment) && !is_numeric($erp_segment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($erp_segment)), __LINE__);
        }
        $this->erp_segment = $erp_segment;
        return $this;
    }
    /**
     * Get old_order_hours value
     * @return float|null
     */
    public function getOld_order_hours()
    {
        return $this->old_order_hours;
    }
    /**
     * Set old_order_hours value
     * @param float $old_order_hours
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setOld_order_hours($old_order_hours = null)
    {
        $this->old_order_hours = $old_order_hours;
        return $this;
    }
    /**
     * Get secondary_consultant value
     * @return int|null
     */
    public function getSecondary_consultant()
    {
        return $this->secondary_consultant;
    }
    /**
     * Set secondary_consultant value
     * @param int $secondary_consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setSecondary_consultant($secondary_consultant = null)
    {
        // validation for constraint: int
        if (!is_null($secondary_consultant) && !is_numeric($secondary_consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($secondary_consultant)), __LINE__);
        }
        $this->secondary_consultant = $secondary_consultant;
        return $this;
    }
    /**
     * Get third_consultant value
     * @return int|null
     */
    public function getThird_consultant()
    {
        return $this->third_consultant;
    }
    /**
     * Set third_consultant value
     * @param int $third_consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setThird_consultant($third_consultant = null)
    {
        // validation for constraint: int
        if (!is_null($third_consultant) && !is_numeric($third_consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($third_consultant)), __LINE__);
        }
        $this->third_consultant = $third_consultant;
        return $this;
    }
    /**
     * Get efaktura_ean value
     * @return string|null
     */
    public function getEfaktura_ean()
    {
        return $this->efaktura_ean;
    }
    /**
     * Set efaktura_ean value
     * @param string $efaktura_ean
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setEfaktura_ean($efaktura_ean = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_ean) && !is_string($efaktura_ean)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_ean)), __LINE__);
        }
        $this->efaktura_ean = $efaktura_ean;
        return $this;
    }
    /**
     * Get efaktura_account value
     * @return string|null
     */
    public function getEfaktura_account()
    {
        return $this->efaktura_account;
    }
    /**
     * Set efaktura_account value
     * @param string $efaktura_account
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setEfaktura_account($efaktura_account = null)
    {
        // validation for constraint: string
        if (!is_null($efaktura_account) && !is_string($efaktura_account)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($efaktura_account)), __LINE__);
        }
        $this->efaktura_account = $efaktura_account;
        return $this;
    }
    /**
     * Get payment_attention value
     * @return string|null
     */
    public function getPayment_attention()
    {
        return $this->payment_attention;
    }
    /**
     * Set payment_attention value
     * @param string $payment_attention
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_attention($payment_attention = null)
    {
        // validation for constraint: string
        if (!is_null($payment_attention) && !is_string($payment_attention)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_attention)), __LINE__);
        }
        $this->payment_attention = $payment_attention;
        return $this;
    }
    /**
     * Get payment_addr1 value
     * @return string|null
     */
    public function getPayment_addr1()
    {
        return $this->payment_addr1;
    }
    /**
     * Set payment_addr1 value
     * @param string $payment_addr1
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_addr1($payment_addr1 = null)
    {
        // validation for constraint: string
        if (!is_null($payment_addr1) && !is_string($payment_addr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_addr1)), __LINE__);
        }
        $this->payment_addr1 = $payment_addr1;
        return $this;
    }
    /**
     * Get payment_addr2 value
     * @return string|null
     */
    public function getPayment_addr2()
    {
        return $this->payment_addr2;
    }
    /**
     * Set payment_addr2 value
     * @param string $payment_addr2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_addr2($payment_addr2 = null)
    {
        // validation for constraint: string
        if (!is_null($payment_addr2) && !is_string($payment_addr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_addr2)), __LINE__);
        }
        $this->payment_addr2 = $payment_addr2;
        return $this;
    }
    /**
     * Get payment_zip value
     * @return string|null
     */
    public function getPayment_zip()
    {
        return $this->payment_zip;
    }
    /**
     * Set payment_zip value
     * @param string $payment_zip
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_zip($payment_zip = null)
    {
        // validation for constraint: string
        if (!is_null($payment_zip) && !is_string($payment_zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_zip)), __LINE__);
        }
        $this->payment_zip = $payment_zip;
        return $this;
    }
    /**
     * Get payment_city value
     * @return string|null
     */
    public function getPayment_city()
    {
        return $this->payment_city;
    }
    /**
     * Set payment_city value
     * @param string $payment_city
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_city($payment_city = null)
    {
        // validation for constraint: string
        if (!is_null($payment_city) && !is_string($payment_city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_city)), __LINE__);
        }
        $this->payment_city = $payment_city;
        return $this;
    }
    /**
     * Get payment_country value
     * @return string|null
     */
    public function getPayment_country()
    {
        return $this->payment_country;
    }
    /**
     * Set payment_country value
     * @param string $payment_country
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_country($payment_country = null)
    {
        // validation for constraint: string
        if (!is_null($payment_country) && !is_string($payment_country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payment_country)), __LINE__);
        }
        $this->payment_country = $payment_country;
        return $this;
    }
    /**
     * Get payment_customer value
     * @return int|null
     */
    public function getPayment_customer()
    {
        return $this->payment_customer;
    }
    /**
     * Set payment_customer value
     * @param int $payment_customer
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPayment_customer($payment_customer = null)
    {
        // validation for constraint: int
        if (!is_null($payment_customer) && !is_numeric($payment_customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($payment_customer)), __LINE__);
        }
        $this->payment_customer = $payment_customer;
        return $this;
    }
    /**
     * Get erp_inc_stamdata value
     * @return int|null
     */
    public function getErp_inc_stamdata()
    {
        return $this->erp_inc_stamdata;
    }
    /**
     * Set erp_inc_stamdata value
     * @param int $erp_inc_stamdata
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setErp_inc_stamdata($erp_inc_stamdata = null)
    {
        // validation for constraint: int
        if (!is_null($erp_inc_stamdata) && !is_numeric($erp_inc_stamdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($erp_inc_stamdata)), __LINE__);
        }
        $this->erp_inc_stamdata = $erp_inc_stamdata;
        return $this;
    }
    /**
     * Get no_confirm_timesheet value
     * @return int|null
     */
    public function getNo_confirm_timesheet()
    {
        return $this->no_confirm_timesheet;
    }
    /**
     * Set no_confirm_timesheet value
     * @param int $no_confirm_timesheet
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setNo_confirm_timesheet($no_confirm_timesheet = null)
    {
        // validation for constraint: int
        if (!is_null($no_confirm_timesheet) && !is_numeric($no_confirm_timesheet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($no_confirm_timesheet)), __LINE__);
        }
        $this->no_confirm_timesheet = $no_confirm_timesheet;
        return $this;
    }
    /**
     * Get default_order_ref value
     * @return string|null
     */
    public function getDefault_order_ref()
    {
        return $this->default_order_ref;
    }
    /**
     * Set default_order_ref value
     * @param string $default_order_ref
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDefault_order_ref($default_order_ref = null)
    {
        // validation for constraint: string
        if (!is_null($default_order_ref) && !is_string($default_order_ref)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($default_order_ref)), __LINE__);
        }
        $this->default_order_ref = $default_order_ref;
        return $this;
    }
    /**
     * Get flags value
     * @return int|null
     */
    public function getFlags()
    {
        return $this->flags;
    }
    /**
     * Set flags value
     * @param int $flags
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setFlags($flags = null)
    {
        // validation for constraint: int
        if (!is_null($flags) && !is_numeric($flags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($flags)), __LINE__);
        }
        $this->flags = $flags;
        return $this;
    }
    /**
     * Get missing_order_ref_notice value
     * @return string|null
     */
    public function getMissing_order_ref_notice()
    {
        return $this->missing_order_ref_notice;
    }
    /**
     * Set missing_order_ref_notice value
     * @param string $missing_order_ref_notice
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setMissing_order_ref_notice($missing_order_ref_notice = null)
    {
        // validation for constraint: string
        if (!is_null($missing_order_ref_notice) && !is_string($missing_order_ref_notice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($missing_order_ref_notice)), __LINE__);
        }
        $this->missing_order_ref_notice = $missing_order_ref_notice;
        return $this;
    }
    /**
     * Get new_order_note_popup value
     * @return bool|null
     */
    public function getNew_order_note_popup()
    {
        return $this->new_order_note_popup;
    }
    /**
     * Set new_order_note_popup value
     * @param bool $new_order_note_popup
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setNew_order_note_popup($new_order_note_popup = null)
    {
        // validation for constraint: boolean
        if (!is_null($new_order_note_popup) && !is_bool($new_order_note_popup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($new_order_note_popup)), __LINE__);
        }
        $this->new_order_note_popup = $new_order_note_popup;
        return $this;
    }
    /**
     * Get diverse_code_1 value
     * @return int|null
     */
    public function getDiverse_code_1()
    {
        return $this->diverse_code_1;
    }
    /**
     * Set diverse_code_1 value
     * @param int $diverse_code_1
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDiverse_code_1($diverse_code_1 = null)
    {
        // validation for constraint: int
        if (!is_null($diverse_code_1) && !is_numeric($diverse_code_1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diverse_code_1)), __LINE__);
        }
        $this->diverse_code_1 = $diverse_code_1;
        return $this;
    }
    /**
     * Get diverse_code_2 value
     * @return int|null
     */
    public function getDiverse_code_2()
    {
        return $this->diverse_code_2;
    }
    /**
     * Set diverse_code_2 value
     * @param int $diverse_code_2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDiverse_code_2($diverse_code_2 = null)
    {
        // validation for constraint: int
        if (!is_null($diverse_code_2) && !is_numeric($diverse_code_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diverse_code_2)), __LINE__);
        }
        $this->diverse_code_2 = $diverse_code_2;
        return $this;
    }
    /**
     * Get diverse_code_3 value
     * @return int|null
     */
    public function getDiverse_code_3()
    {
        return $this->diverse_code_3;
    }
    /**
     * Set diverse_code_3 value
     * @param int $diverse_code_3
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDiverse_code_3($diverse_code_3 = null)
    {
        // validation for constraint: int
        if (!is_null($diverse_code_3) && !is_numeric($diverse_code_3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diverse_code_3)), __LINE__);
        }
        $this->diverse_code_3 = $diverse_code_3;
        return $this;
    }
    /**
     * Get import_tag value
     * @return string|null
     */
    public function getImport_tag()
    {
        return $this->import_tag;
    }
    /**
     * Set import_tag value
     * @param string $import_tag
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setImport_tag($import_tag = null)
    {
        // validation for constraint: string
        if (!is_null($import_tag) && !is_string($import_tag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($import_tag)), __LINE__);
        }
        $this->import_tag = $import_tag;
        return $this;
    }
    /**
     * Get fixed_ordernumber value
     * @return string|null
     */
    public function getFixed_ordernumber()
    {
        return $this->fixed_ordernumber;
    }
    /**
     * Set fixed_ordernumber value
     * @param string $fixed_ordernumber
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setFixed_ordernumber($fixed_ordernumber = null)
    {
        // validation for constraint: string
        if (!is_null($fixed_ordernumber) && !is_string($fixed_ordernumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fixed_ordernumber)), __LINE__);
        }
        $this->fixed_ordernumber = $fixed_ordernumber;
        return $this;
    }
    /**
     * Get order_notebar value
     * @return string|null
     */
    public function getOrder_notebar()
    {
        return $this->order_notebar;
    }
    /**
     * Set order_notebar value
     * @param string $order_notebar
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setOrder_notebar($order_notebar = null)
    {
        // validation for constraint: string
        if (!is_null($order_notebar) && !is_string($order_notebar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($order_notebar)), __LINE__);
        }
        $this->order_notebar = $order_notebar;
        return $this;
    }
    /**
     * Get partners_agreement_end value
     * @return int|null
     */
    public function getPartners_agreement_end()
    {
        return $this->partners_agreement_end;
    }
    /**
     * Set partners_agreement_end value
     * @param int $partners_agreement_end
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setPartners_agreement_end($partners_agreement_end = null)
    {
        // validation for constraint: int
        if (!is_null($partners_agreement_end) && !is_numeric($partners_agreement_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($partners_agreement_end)), __LINE__);
        }
        $this->partners_agreement_end = $partners_agreement_end;
        return $this;
    }
    /**
     * Get timesheet_receipt_receivers value
     * @return string|null
     */
    public function getTimesheet_receipt_receivers()
    {
        return $this->timesheet_receipt_receivers;
    }
    /**
     * Set timesheet_receipt_receivers value
     * @param string $timesheet_receipt_receivers
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setTimesheet_receipt_receivers($timesheet_receipt_receivers = null)
    {
        // validation for constraint: string
        if (!is_null($timesheet_receipt_receivers) && !is_string($timesheet_receipt_receivers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timesheet_receipt_receivers)), __LINE__);
        }
        $this->timesheet_receipt_receivers = $timesheet_receipt_receivers;
        return $this;
    }
    /**
     * Get notebar value
     * @return string|null
     */
    public function getNotebar()
    {
        return $this->notebar;
    }
    /**
     * Set notebar value
     * @param string $notebar
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setNotebar($notebar = null)
    {
        // validation for constraint: string
        if (!is_null($notebar) && !is_string($notebar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notebar)), __LINE__);
        }
        $this->notebar = $notebar;
        return $this;
    }
    /**
     * Get order_temp_limit value
     * @return int|null
     */
    public function getOrder_temp_limit()
    {
        return $this->order_temp_limit;
    }
    /**
     * Set order_temp_limit value
     * @param int $order_temp_limit
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setOrder_temp_limit($order_temp_limit = null)
    {
        // validation for constraint: int
        if (!is_null($order_temp_limit) && !is_numeric($order_temp_limit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($order_temp_limit)), __LINE__);
        }
        $this->order_temp_limit = $order_temp_limit;
        return $this;
    }
    /**
     * Get stampclock value
     * @return int|null
     */
    public function getStampclock()
    {
        return $this->stampclock;
    }
    /**
     * Set stampclock value
     * @param int $stampclock
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setStampclock($stampclock = null)
    {
        // validation for constraint: int
        if (!is_null($stampclock) && !is_numeric($stampclock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($stampclock)), __LINE__);
        }
        $this->stampclock = $stampclock;
        return $this;
    }
    /**
     * Get invoice_email value
     * @return string|null
     */
    public function getInvoice_email()
    {
        return $this->invoice_email;
    }
    /**
     * Set invoice_email value
     * @param string $invoice_email
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setInvoice_email($invoice_email = null)
    {
        // validation for constraint: string
        if (!is_null($invoice_email) && !is_string($invoice_email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoice_email)), __LINE__);
        }
        $this->invoice_email = $invoice_email;
        return $this;
    }
    /**
     * Get baids value
     * @return int[]|null
     */
    public function getBaids()
    {
        return $this->baids;
    }
    /**
     * Set baids value
     * @throws \InvalidArgumentException
     * @param int[] $baids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setBaids(array $baids = array())
    {
        foreach ($baids as $axpCustomerRawBaidsItem) {
            // validation for constraint: itemType
            if (!is_numeric($axpCustomerRawBaidsItem)) {
                throw new \InvalidArgumentException(sprintf('The baids property can only contain items of int, "%s" given', is_object($axpCustomerRawBaidsItem) ? get_class($axpCustomerRawBaidsItem) : gettype($axpCustomerRawBaidsItem)), __LINE__);
            }
        }
        $this->baids = $baids;
        return $this;
    }
    /**
     * Add item to baids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function addToBaids($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The baids property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->baids[] = $item;
        return $this;
    }
    /**
     * Get guest_data value
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData[]|null
     */
    public function getGuest_data()
    {
        return $this->guest_data;
    }
    /**
     * Set guest_data value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData[] $guest_data
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setGuest_data(array $guest_data = array())
    {
        foreach ($guest_data as $axpCustomerRawGuest_dataItem) {
            // validation for constraint: itemType
            if (!$axpCustomerRawGuest_dataItem instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData) {
                throw new \InvalidArgumentException(sprintf('The guest_data property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData, "%s" given', is_object($axpCustomerRawGuest_dataItem) ? get_class($axpCustomerRawGuest_dataItem) : gettype($axpCustomerRawGuest_dataItem)), __LINE__);
            }
        }
        $this->guest_data = $guest_data;
        return $this;
    }
    /**
     * Add item to guest_data value
     * @throws \InvalidArgumentException
     * @param \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function addToGuest_data(\App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData) {
            throw new \InvalidArgumentException(sprintf('The guest_data property can only contain items of \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpGuestfieldData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->guest_data[] = $item;
        return $this;
    }
    /**
     * Get dids value
     * @return int[]|null
     */
    public function getDids()
    {
        return $this->dids;
    }
    /**
     * Set dids value
     * @throws \InvalidArgumentException
     * @param int[] $dids
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setDids(array $dids = array())
    {
        foreach ($dids as $axpCustomerRawDidsItem) {
            // validation for constraint: itemType
            if (!is_numeric($axpCustomerRawDidsItem)) {
                throw new \InvalidArgumentException(sprintf('The dids property can only contain items of int, "%s" given', is_object($axpCustomerRawDidsItem) ? get_class($axpCustomerRawDidsItem) : gettype($axpCustomerRawDidsItem)), __LINE__);
            }
        }
        $this->dids = $dids;
        return $this;
    }
    /**
     * Add item to dids value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function addToDids($item)
    {
        // validation for constraint: itemType
        if (!is_numeric($item)) {
            throw new \InvalidArgumentException(sprintf('The dids property can only contain items of int, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->dids[] = $item;
        return $this;
    }
    /**
     * Get homepage2 value
     * @return string|null
     */
    public function getHomepage2()
    {
        return $this->homepage2;
    }
    /**
     * Set homepage2 value
     * @param string $homepage2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public function setHomepage2($homepage2 = null)
    {
        // validation for constraint: string
        if (!is_null($homepage2) && !is_string($homepage2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homepage2)), __LINE__);
        }
        $this->homepage2 = $homepage2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomerRaw
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
