<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpCustomer StructType
 * @subpackage Structs
 */
class AxpCustomer extends AbstractStructBase
{
    /**
     * The cust_id
     * @var int
     */
    public $cust_id;
    /**
     * The cust_no
     * @var string
     */
    public $cust_no;
    /**
     * The company
     * @var string
     */
    public $company;
    /**
     * The addr1
     * @var string
     */
    public $addr1;
    /**
     * The addr2
     * @var string
     */
    public $addr2;
    /**
     * The zip
     * @var string
     */
    public $zip;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The company_no
     * @var string
     */
    public $company_no;
    /**
     * The employees
     * @var int
     */
    public $employees;
    /**
     * The phone
     * @var string
     */
    public $phone;
    /**
     * The phone2
     * @var string
     */
    public $phone2;
    /**
     * The fax
     * @var string
     */
    public $fax;
    /**
     * The email
     * @var string
     */
    public $email;
    /**
     * The homepage
     * @var string
     */
    public $homepage;
    /**
     * The active
     * @var bool
     */
    public $active;
    /**
     * The customergroup
     * @var string
     */
    public $customergroup;
    /**
     * The discount
     * @var int
     */
    public $discount;
    /**
     * The consultant
     * @var string
     */
    public $consultant;
    /**
     * The secondary_consultant
     * @var string
     */
    public $secondary_consultant;
    /**
     * The departments
     * Meta informations extracted from the WSDL
     * - arrayType: xsd:string[]
     * - ref: SOAP-ENC:arrayType
     * @var string[]
     */
    public $departments;
    /**
     * The notes
     * @var string
     */
    public $notes;
    /**
     * The partners_agreement
     * @var bool
     */
    public $partners_agreement;
    /**
     * The partners_agreement_end
     * @var string
     */
    public $partners_agreement_end;
    /**
     * The customergroup_id
     * @var int
     */
    public $customergroup_id;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * Constructor method for AxpCustomer
     * @uses AxpCustomer::setCust_id()
     * @uses AxpCustomer::setCust_no()
     * @uses AxpCustomer::setCompany()
     * @uses AxpCustomer::setAddr1()
     * @uses AxpCustomer::setAddr2()
     * @uses AxpCustomer::setZip()
     * @uses AxpCustomer::setCity()
     * @uses AxpCustomer::setCompany_no()
     * @uses AxpCustomer::setEmployees()
     * @uses AxpCustomer::setPhone()
     * @uses AxpCustomer::setPhone2()
     * @uses AxpCustomer::setFax()
     * @uses AxpCustomer::setEmail()
     * @uses AxpCustomer::setHomepage()
     * @uses AxpCustomer::setActive()
     * @uses AxpCustomer::setCustomergroup()
     * @uses AxpCustomer::setDiscount()
     * @uses AxpCustomer::setConsultant()
     * @uses AxpCustomer::setSecondary_consultant()
     * @uses AxpCustomer::setDepartments()
     * @uses AxpCustomer::setNotes()
     * @uses AxpCustomer::setPartners_agreement()
     * @uses AxpCustomer::setPartners_agreement_end()
     * @uses AxpCustomer::setCustomergroup_id()
     * @uses AxpCustomer::setCountry()
     * @param int $cust_id
     * @param string $cust_no
     * @param string $company
     * @param string $addr1
     * @param string $addr2
     * @param string $zip
     * @param string $city
     * @param string $company_no
     * @param int $employees
     * @param string $phone
     * @param string $phone2
     * @param string $fax
     * @param string $email
     * @param string $homepage
     * @param bool $active
     * @param string $customergroup
     * @param int $discount
     * @param string $consultant
     * @param string $secondary_consultant
     * @param string[] $departments
     * @param string $notes
     * @param bool $partners_agreement
     * @param string $partners_agreement_end
     * @param int $customergroup_id
     * @param string $country
     */
    public function __construct($cust_id = null, $cust_no = null, $company = null, $addr1 = null, $addr2 = null, $zip = null, $city = null, $company_no = null, $employees = null, $phone = null, $phone2 = null, $fax = null, $email = null, $homepage = null, $active = null, $customergroup = null, $discount = null, $consultant = null, $secondary_consultant = null, array $departments = array(), $notes = null, $partners_agreement = null, $partners_agreement_end = null, $customergroup_id = null, $country = null)
    {
        $this
            ->setCust_id($cust_id)
            ->setCust_no($cust_no)
            ->setCompany($company)
            ->setAddr1($addr1)
            ->setAddr2($addr2)
            ->setZip($zip)
            ->setCity($city)
            ->setCompany_no($company_no)
            ->setEmployees($employees)
            ->setPhone($phone)
            ->setPhone2($phone2)
            ->setFax($fax)
            ->setEmail($email)
            ->setHomepage($homepage)
            ->setActive($active)
            ->setCustomergroup($customergroup)
            ->setDiscount($discount)
            ->setConsultant($consultant)
            ->setSecondary_consultant($secondary_consultant)
            ->setDepartments($departments)
            ->setNotes($notes)
            ->setPartners_agreement($partners_agreement)
            ->setPartners_agreement_end($partners_agreement_end)
            ->setCustomergroup_id($customergroup_id)
            ->setCountry($country);
    }
    /**
     * Get cust_id value
     * @return int|null
     */
    public function getCust_id()
    {
        return $this->cust_id;
    }
    /**
     * Set cust_id value
     * @param int $cust_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCust_id($cust_id = null)
    {
        // validation for constraint: int
        if (!is_null($cust_id) && !is_numeric($cust_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cust_id)), __LINE__);
        }
        $this->cust_id = $cust_id;
        return $this;
    }
    /**
     * Get cust_no value
     * @return string|null
     */
    public function getCust_no()
    {
        return $this->cust_no;
    }
    /**
     * Set cust_no value
     * @param string $cust_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCust_no($cust_no = null)
    {
        // validation for constraint: string
        if (!is_null($cust_no) && !is_string($cust_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cust_no)), __LINE__);
        }
        $this->cust_no = $cust_no;
        return $this;
    }
    /**
     * Get company value
     * @return string|null
     */
    public function getCompany()
    {
        return $this->company;
    }
    /**
     * Set company value
     * @param string $company
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCompany($company = null)
    {
        // validation for constraint: string
        if (!is_null($company) && !is_string($company)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company)), __LINE__);
        }
        $this->company = $company;
        return $this;
    }
    /**
     * Get addr1 value
     * @return string|null
     */
    public function getAddr1()
    {
        return $this->addr1;
    }
    /**
     * Set addr1 value
     * @param string $addr1
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setAddr1($addr1 = null)
    {
        // validation for constraint: string
        if (!is_null($addr1) && !is_string($addr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr1)), __LINE__);
        }
        $this->addr1 = $addr1;
        return $this;
    }
    /**
     * Get addr2 value
     * @return string|null
     */
    public function getAddr2()
    {
        return $this->addr2;
    }
    /**
     * Set addr2 value
     * @param string $addr2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setAddr2($addr2 = null)
    {
        // validation for constraint: string
        if (!is_null($addr2) && !is_string($addr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr2)), __LINE__);
        }
        $this->addr2 = $addr2;
        return $this;
    }
    /**
     * Get zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->zip;
    }
    /**
     * Set zip value
     * @param string $zip
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->zip = $zip;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get company_no value
     * @return string|null
     */
    public function getCompany_no()
    {
        return $this->company_no;
    }
    /**
     * Set company_no value
     * @param string $company_no
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCompany_no($company_no = null)
    {
        // validation for constraint: string
        if (!is_null($company_no) && !is_string($company_no)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($company_no)), __LINE__);
        }
        $this->company_no = $company_no;
        return $this;
    }
    /**
     * Get employees value
     * @return int|null
     */
    public function getEmployees()
    {
        return $this->employees;
    }
    /**
     * Set employees value
     * @param int $employees
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setEmployees($employees = null)
    {
        // validation for constraint: int
        if (!is_null($employees) && !is_numeric($employees)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($employees)), __LINE__);
        }
        $this->employees = $employees;
        return $this;
    }
    /**
     * Get phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param string $phone
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->phone = $phone;
        return $this;
    }
    /**
     * Get phone2 value
     * @return string|null
     */
    public function getPhone2()
    {
        return $this->phone2;
    }
    /**
     * Set phone2 value
     * @param string $phone2
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setPhone2($phone2 = null)
    {
        // validation for constraint: string
        if (!is_null($phone2) && !is_string($phone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone2)), __LINE__);
        }
        $this->phone2 = $phone2;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get homepage value
     * @return string|null
     */
    public function getHomepage()
    {
        return $this->homepage;
    }
    /**
     * Set homepage value
     * @param string $homepage
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setHomepage($homepage = null)
    {
        // validation for constraint: string
        if (!is_null($homepage) && !is_string($homepage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homepage)), __LINE__);
        }
        $this->homepage = $homepage;
        return $this;
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get customergroup value
     * @return string|null
     */
    public function getCustomergroup()
    {
        return $this->customergroup;
    }
    /**
     * Set customergroup value
     * @param string $customergroup
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCustomergroup($customergroup = null)
    {
        // validation for constraint: string
        if (!is_null($customergroup) && !is_string($customergroup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customergroup)), __LINE__);
        }
        $this->customergroup = $customergroup;
        return $this;
    }
    /**
     * Get discount value
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->discount;
    }
    /**
     * Set discount value
     * @param int $discount
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setDiscount($discount = null)
    {
        // validation for constraint: int
        if (!is_null($discount) && !is_numeric($discount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($discount)), __LINE__);
        }
        $this->discount = $discount;
        return $this;
    }
    /**
     * Get consultant value
     * @return string|null
     */
    public function getConsultant()
    {
        return $this->consultant;
    }
    /**
     * Set consultant value
     * @param string $consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setConsultant($consultant = null)
    {
        // validation for constraint: string
        if (!is_null($consultant) && !is_string($consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($consultant)), __LINE__);
        }
        $this->consultant = $consultant;
        return $this;
    }
    /**
     * Get secondary_consultant value
     * @return string|null
     */
    public function getSecondary_consultant()
    {
        return $this->secondary_consultant;
    }
    /**
     * Set secondary_consultant value
     * @param string $secondary_consultant
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setSecondary_consultant($secondary_consultant = null)
    {
        // validation for constraint: string
        if (!is_null($secondary_consultant) && !is_string($secondary_consultant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($secondary_consultant)), __LINE__);
        }
        $this->secondary_consultant = $secondary_consultant;
        return $this;
    }
    /**
     * Get departments value
     * @return string[]|null
     */
    public function getDepartments()
    {
        return $this->departments;
    }
    /**
     * Set departments value
     * @throws \InvalidArgumentException
     * @param string[] $departments
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setDepartments(array $departments = array())
    {
        foreach ($departments as $axpCustomerDepartmentsItem) {
            // validation for constraint: itemType
            if (!is_string($axpCustomerDepartmentsItem)) {
                throw new \InvalidArgumentException(sprintf('The departments property can only contain items of string, "%s" given', is_object($axpCustomerDepartmentsItem) ? get_class($axpCustomerDepartmentsItem) : gettype($axpCustomerDepartmentsItem)), __LINE__);
            }
        }
        $this->departments = $departments;
        return $this;
    }
    /**
     * Add item to departments value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function addToDepartments($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The departments property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->departments[] = $item;
        return $this;
    }
    /**
     * Get notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->notes;
    }
    /**
     * Set notes value
     * @param string $notes
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->notes = $notes;
        return $this;
    }
    /**
     * Get partners_agreement value
     * @return bool|null
     */
    public function getPartners_agreement()
    {
        return $this->partners_agreement;
    }
    /**
     * Set partners_agreement value
     * @param bool $partners_agreement
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setPartners_agreement($partners_agreement = null)
    {
        // validation for constraint: boolean
        if (!is_null($partners_agreement) && !is_bool($partners_agreement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($partners_agreement)), __LINE__);
        }
        $this->partners_agreement = $partners_agreement;
        return $this;
    }
    /**
     * Get partners_agreement_end value
     * @return string|null
     */
    public function getPartners_agreement_end()
    {
        return $this->partners_agreement_end;
    }
    /**
     * Set partners_agreement_end value
     * @param string $partners_agreement_end
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setPartners_agreement_end($partners_agreement_end = null)
    {
        // validation for constraint: string
        if (!is_null($partners_agreement_end) && !is_string($partners_agreement_end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($partners_agreement_end)), __LINE__);
        }
        $this->partners_agreement_end = $partners_agreement_end;
        return $this;
    }
    /**
     * Get customergroup_id value
     * @return int|null
     */
    public function getCustomergroup_id()
    {
        return $this->customergroup_id;
    }
    /**
     * Set customergroup_id value
     * @param int $customergroup_id
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCustomergroup_id($customergroup_id = null)
    {
        // validation for constraint: int
        if (!is_null($customergroup_id) && !is_numeric($customergroup_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customergroup_id)), __LINE__);
        }
        $this->customergroup_id = $customergroup_id;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpCustomer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
