<?php

namespace App\ExternalApis\ConsendoAxp\Soap\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AxpArea StructType
 * @subpackage Structs
 */
class AxpArea extends AbstractStructBase
{
    /**
     * The aid
     * @var int
     */
    public $aid;
    /**
     * The label
     * @var string
     */
    public $label;
    /**
     * The descr
     * @var string
     */
    public $descr;
    /**
     * The sid
     * @var int
     */
    public $sid;
    /**
     * The intro
     * @var string
     */
    public $intro;
    /**
     * Constructor method for AxpArea
     * @uses AxpArea::setAid()
     * @uses AxpArea::setLabel()
     * @uses AxpArea::setDescr()
     * @uses AxpArea::setSid()
     * @uses AxpArea::setIntro()
     * @param int $aid
     * @param string $label
     * @param string $descr
     * @param int $sid
     * @param string $intro
     */
    public function __construct($aid = null, $label = null, $descr = null, $sid = null, $intro = null)
    {
        $this
            ->setAid($aid)
            ->setLabel($label)
            ->setDescr($descr)
            ->setSid($sid)
            ->setIntro($intro);
    }
    /**
     * Get aid value
     * @return int|null
     */
    public function getAid()
    {
        return $this->aid;
    }
    /**
     * Set aid value
     * @param int $aid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public function setAid($aid = null)
    {
        // validation for constraint: int
        if (!is_null($aid) && !is_numeric($aid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aid)), __LINE__);
        }
        $this->aid = $aid;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get descr value
     * @return string|null
     */
    public function getDescr()
    {
        return $this->descr;
    }
    /**
     * Set descr value
     * @param string $descr
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public function setDescr($descr = null)
    {
        // validation for constraint: string
        if (!is_null($descr) && !is_string($descr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descr)), __LINE__);
        }
        $this->descr = $descr;
        return $this;
    }
    /**
     * Get sid value
     * @return int|null
     */
    public function getSid()
    {
        return $this->sid;
    }
    /**
     * Set sid value
     * @param int $sid
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public function setSid($sid = null)
    {
        // validation for constraint: int
        if (!is_null($sid) && !is_numeric($sid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sid)), __LINE__);
        }
        $this->sid = $sid;
        return $this;
    }
    /**
     * Get intro value
     * @return string|null
     */
    public function getIntro()
    {
        return $this->intro;
    }
    /**
     * Set intro value
     * @param string $intro
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public function setIntro($intro = null)
    {
        // validation for constraint: string
        if (!is_null($intro) && !is_string($intro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intro)), __LINE__);
        }
        $this->intro = $intro;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \App\ExternalApis\ConsendoAxp\Soap\StructType\AxpArea
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
