<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set ServiceType
 * @subpackage Services
 */
class Set extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named setAxpOrderAlert
     * Meta informations extracted from the WSDL
     * - documentation: sets an axp order alert by order id or orid - visibleDate is only set on I orders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $order_id
     * @param string $orid
     * @param string $autoAlertDate
     * @param string $manualAlertDate
     * @param string $alertMessage
     * @param string $popUpOnAlertTime
     * @param string $popUpOnEnterOrder
     * @param string $includeOrderDescription
     * @param string $visibleDate
     * @return boolean|bool
     */
    public function setAxpOrderAlert($handle, $order_id, $orid, $autoAlertDate, $manualAlertDate, $alertMessage, $popUpOnAlertTime, $popUpOnEnterOrder, $includeOrderDescription, $visibleDate)
    {
        try {
            $this->setResult(self::getSoapClient()->setAxpOrderAlert($handle, $order_id, $orid, $autoAlertDate, $manualAlertDate, $alertMessage, $popUpOnAlertTime, $popUpOnEnterOrder, $includeOrderDescription, $visibleDate));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
