<?php

namespace App\ExternalApis\ConsendoAxp\Soap\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Extend ServiceType
 * @subpackage Services
 */
class Extend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named extendAxpTempOrder
     * Meta informations extracted from the WSDL
     * - documentation: Extends order periode, and extends temps period if tid is given in array
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $handle
     * @param string $orid
     * @param string $from_date
     * @param string $to_date
     * @param string $tids
     * @return boolean|bool
     */
    public function extendAxpTempOrder($handle, $orid, $from_date, $to_date, $tids)
    {
        try {
            $this->setResult(self::getSoapClient()->extendAxpTempOrder($handle, $orid, $from_date, $to_date, $tids));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return boolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
