<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for whenAndWhereDetails StructType
 * @subpackage Structs
 */
class WhenAndWhereDetails extends AbstractStructBase
{
    /**
     * The date
     * @var string
     */
    public $date;
    /**
     * The time
     * @var string
     */
    public $time;
    /**
     * The station
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $station;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\RentalAddress
     */
    public $address;
    /**
     * The deliveryMileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deliveryMileage;
    /**
     * The collectionMileage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $collectionMileage;
    /**
     * The instructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\Instructions
     */
    public $instructions;
    /**
     * Constructor method for whenAndWhereDetails
     * @uses WhenAndWhereDetails::setDate()
     * @uses WhenAndWhereDetails::setTime()
     * @uses WhenAndWhereDetails::setStation()
     * @uses WhenAndWhereDetails::setAddress()
     * @uses WhenAndWhereDetails::setDeliveryMileage()
     * @uses WhenAndWhereDetails::setCollectionMileage()
     * @uses WhenAndWhereDetails::setInstructions()
     * @param string $date
     * @param string $time
     * @param string $station
     * @param \GreenwayDirectService\StructType\RentalAddress $address
     * @param string $deliveryMileage
     * @param string $collectionMileage
     * @param \GreenwayDirectService\StructType\Instructions $instructions
     */
    public function __construct($date = null, $time = null, $station = null, \GreenwayDirectService\StructType\RentalAddress $address = null, $deliveryMileage = null, $collectionMileage = null, \GreenwayDirectService\StructType\Instructions $instructions = null)
    {
        $this
            ->setDate($date)
            ->setTime($time)
            ->setStation($station)
            ->setAddress($address)
            ->setDeliveryMileage($deliveryMileage)
            ->setCollectionMileage($collectionMileage)
            ->setInstructions($instructions);
    }
    /**
     * Get date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->date;
    }
    /**
     * Set date value
     * @param string $date
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->date = $date;
        return $this;
    }
    /**
     * Get time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get station value
     * @return string|null
     */
    public function getStation()
    {
        return $this->station;
    }
    /**
     * Set station value
     * @param string $station
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setStation($station = null)
    {
        // validation for constraint: string
        if (!is_null($station) && !is_string($station)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($station)), __LINE__);
        }
        $this->station = $station;
        return $this;
    }
    /**
     * Get address value
     * @return \GreenwayDirectService\StructType\RentalAddress|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \GreenwayDirectService\StructType\RentalAddress $address
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setAddress(\GreenwayDirectService\StructType\RentalAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get deliveryMileage value
     * @return string|null
     */
    public function getDeliveryMileage()
    {
        return $this->deliveryMileage;
    }
    /**
     * Set deliveryMileage value
     * @param string $deliveryMileage
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setDeliveryMileage($deliveryMileage = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMileage) && !is_string($deliveryMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deliveryMileage)), __LINE__);
        }
        $this->deliveryMileage = $deliveryMileage;
        return $this;
    }
    /**
     * Get collectionMileage value
     * @return string|null
     */
    public function getCollectionMileage()
    {
        return $this->collectionMileage;
    }
    /**
     * Set collectionMileage value
     * @param string $collectionMileage
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setCollectionMileage($collectionMileage = null)
    {
        // validation for constraint: string
        if (!is_null($collectionMileage) && !is_string($collectionMileage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($collectionMileage)), __LINE__);
        }
        $this->collectionMileage = $collectionMileage;
        return $this;
    }
    /**
     * Get instructions value
     * @return \GreenwayDirectService\StructType\Instructions|null
     */
    public function getInstructions()
    {
        return $this->instructions;
    }
    /**
     * Set instructions value
     * @param \GreenwayDirectService\StructType\Instructions $instructions
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public function setInstructions(\GreenwayDirectService\StructType\Instructions $instructions = null)
    {
        $this->instructions = $instructions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
