<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rentalAddress StructType
 * @subpackage Structs
 */
class RentalAddress extends AbstractStructBase
{
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The address1
     * @var string
     */
    public $address1;
    /**
     * The address2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address2;
    /**
     * The address3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address3;
    /**
     * The address4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $address4;
    /**
     * The city
     * @var string
     */
    public $city;
    /**
     * The country
     * @var string
     */
    public $country;
    /**
     * The postCode
     * @var string
     */
    public $postCode;
    /**
     * The phone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\PhoneNumber
     */
    public $phone;
    /**
     * Constructor method for rentalAddress
     * @uses RentalAddress::setType()
     * @uses RentalAddress::setAddress1()
     * @uses RentalAddress::setAddress2()
     * @uses RentalAddress::setAddress3()
     * @uses RentalAddress::setAddress4()
     * @uses RentalAddress::setCity()
     * @uses RentalAddress::setCountry()
     * @uses RentalAddress::setPostCode()
     * @uses RentalAddress::setPhone()
     * @param string $type
     * @param string $address1
     * @param string $address2
     * @param string $address3
     * @param string $address4
     * @param string $city
     * @param string $country
     * @param string $postCode
     * @param \GreenwayDirectService\StructType\PhoneNumber $phone
     */
    public function __construct($type = null, $address1 = null, $address2 = null, $address3 = null, $address4 = null, $city = null, $country = null, $postCode = null, \GreenwayDirectService\StructType\PhoneNumber $phone = null)
    {
        $this
            ->setType($type)
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setAddress3($address3)
            ->setAddress4($address4)
            ->setCity($city)
            ->setCountry($country)
            ->setPostCode($postCode)
            ->setPhone($phone);
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \GreenwayDirectService\EnumType\AddressType::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\AddressType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\AddressType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \GreenwayDirectService\EnumType\AddressType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get address1 value
     * @return string|null
     */
    public function getAddress1()
    {
        return $this->address1;
    }
    /**
     * Set address1 value
     * @param string $address1
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        $this->address1 = $address1;
        return $this;
    }
    /**
     * Get address2 value
     * @return string|null
     */
    public function getAddress2()
    {
        return $this->address2;
    }
    /**
     * Set address2 value
     * @param string $address2
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        $this->address2 = $address2;
        return $this;
    }
    /**
     * Get address3 value
     * @return string|null
     */
    public function getAddress3()
    {
        return $this->address3;
    }
    /**
     * Set address3 value
     * @param string $address3
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setAddress3($address3 = null)
    {
        // validation for constraint: string
        if (!is_null($address3) && !is_string($address3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address3)), __LINE__);
        }
        $this->address3 = $address3;
        return $this;
    }
    /**
     * Get address4 value
     * @return string|null
     */
    public function getAddress4()
    {
        return $this->address4;
    }
    /**
     * Set address4 value
     * @param string $address4
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setAddress4($address4 = null)
    {
        // validation for constraint: string
        if (!is_null($address4) && !is_string($address4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address4)), __LINE__);
        }
        $this->address4 = $address4;
        return $this;
    }
    /**
     * Get city value
     * @return string|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param string $city
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->city = $city;
        return $this;
    }
    /**
     * Get country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get postCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->postCode;
    }
    /**
     * Set postCode value
     * @param string $postCode
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->postCode = $postCode;
        return $this;
    }
    /**
     * Get phone value
     * @return \GreenwayDirectService\StructType\PhoneNumber|null
     */
    public function getPhone()
    {
        return $this->phone;
    }
    /**
     * Set phone value
     * @param \GreenwayDirectService\StructType\PhoneNumber $phone
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public function setPhone(\GreenwayDirectService\StructType\PhoneNumber $phone = null)
    {
        $this->phone = $phone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\RentalAddress
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
