<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for licence StructType
 * @subpackage Structs
 */
class Licence extends AbstractStructBase
{
    /**
     * The number
     * @var string
     */
    public $number;
    /**
     * The issueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The expiryDate
     * @var string
     */
    public $expiryDate;
    /**
     * The issuingCity
     * @var string
     */
    public $issuingCity;
    /**
     * The issuingCountry
     * @var string
     */
    public $issuingCountry;
    /**
     * Constructor method for licence
     * @uses Licence::setNumber()
     * @uses Licence::setIssueDate()
     * @uses Licence::setExpiryDate()
     * @uses Licence::setIssuingCity()
     * @uses Licence::setIssuingCountry()
     * @param string $number
     * @param string $issueDate
     * @param string $expiryDate
     * @param string $issuingCity
     * @param string $issuingCountry
     */
    public function __construct($number = null, $issueDate = null, $expiryDate = null, $issuingCity = null, $issuingCountry = null)
    {
        $this
            ->setNumber($number)
            ->setIssueDate($issueDate)
            ->setExpiryDate($expiryDate)
            ->setIssuingCity($issuingCity)
            ->setIssuingCountry($issuingCountry);
    }
    /**
     * Get number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param string $number
     * @return \GreenwayDirectService\StructType\Licence
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \GreenwayDirectService\StructType\Licence
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \GreenwayDirectService\StructType\Licence
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get issuingCity value
     * @return string|null
     */
    public function getIssuingCity()
    {
        return $this->issuingCity;
    }
    /**
     * Set issuingCity value
     * @param string $issuingCity
     * @return \GreenwayDirectService\StructType\Licence
     */
    public function setIssuingCity($issuingCity = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCity) && !is_string($issuingCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingCity)), __LINE__);
        }
        $this->issuingCity = $issuingCity;
        return $this;
    }
    /**
     * Get issuingCountry value
     * @return string|null
     */
    public function getIssuingCountry()
    {
        return $this->issuingCountry;
    }
    /**
     * Set issuingCountry value
     * @param string $issuingCountry
     * @return \GreenwayDirectService\StructType\Licence
     */
    public function setIssuingCountry($issuingCountry = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCountry) && !is_string($issuingCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuingCountry)), __LINE__);
        }
        $this->issuingCountry = $issuingCountry;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Licence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
