<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driverDetails StructType
 * @subpackage Structs
 */
class DriverDetails extends AbstractStructBase
{
    /**
     * The title
     * @var string
     */
    public $title;
    /**
     * The firstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $firstName;
    /**
     * The lastName
     * @var string
     */
    public $lastName;
    /**
     * The address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\RentalAddress
     */
    public $address;
    /**
     * The countryOfResidence
     * @var string
     */
    public $countryOfResidence;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The licence
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\Licence
     */
    public $licence;
    /**
     * The dateOfBirth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateOfBirth;
    /**
     * Constructor method for driverDetails
     * @uses DriverDetails::setTitle()
     * @uses DriverDetails::setFirstName()
     * @uses DriverDetails::setLastName()
     * @uses DriverDetails::setAddress()
     * @uses DriverDetails::setCountryOfResidence()
     * @uses DriverDetails::setEmail()
     * @uses DriverDetails::setLicence()
     * @uses DriverDetails::setDateOfBirth()
     * @param string $title
     * @param string $firstName
     * @param string $lastName
     * @param \GreenwayDirectService\StructType\RentalAddress $address
     * @param string $countryOfResidence
     * @param string $email
     * @param \GreenwayDirectService\StructType\Licence $licence
     * @param string $dateOfBirth
     */
    public function __construct($title = null, $firstName = null, $lastName = null, \GreenwayDirectService\StructType\RentalAddress $address = null, $countryOfResidence = null, $email = null, \GreenwayDirectService\StructType\Licence $licence = null, $dateOfBirth = null)
    {
        $this
            ->setTitle($title)
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setAddress($address)
            ->setCountryOfResidence($countryOfResidence)
            ->setEmail($email)
            ->setLicence($licence)
            ->setDateOfBirth($dateOfBirth);
    }
    /**
     * Get title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->title;
    }
    /**
     * Set title value
     * @param string $title
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($title)), __LINE__);
        }
        $this->title = $title;
        return $this;
    }
    /**
     * Get firstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->firstName;
    }
    /**
     * Set firstName value
     * @param string $firstName
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        $this->firstName = $firstName;
        return $this;
    }
    /**
     * Get lastName value
     * @return string|null
     */
    public function getLastName()
    {
        return $this->lastName;
    }
    /**
     * Set lastName value
     * @param string $lastName
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        $this->lastName = $lastName;
        return $this;
    }
    /**
     * Get address value
     * @return \GreenwayDirectService\StructType\RentalAddress|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param \GreenwayDirectService\StructType\RentalAddress $address
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setAddress(\GreenwayDirectService\StructType\RentalAddress $address = null)
    {
        $this->address = $address;
        return $this;
    }
    /**
     * Get countryOfResidence value
     * @return string|null
     */
    public function getCountryOfResidence()
    {
        return $this->countryOfResidence;
    }
    /**
     * Set countryOfResidence value
     * @param string $countryOfResidence
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setCountryOfResidence($countryOfResidence = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfResidence) && !is_string($countryOfResidence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryOfResidence)), __LINE__);
        }
        $this->countryOfResidence = $countryOfResidence;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get licence value
     * @return \GreenwayDirectService\StructType\Licence|null
     */
    public function getLicence()
    {
        return $this->licence;
    }
    /**
     * Set licence value
     * @param \GreenwayDirectService\StructType\Licence $licence
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setLicence(\GreenwayDirectService\StructType\Licence $licence = null)
    {
        $this->licence = $licence;
        return $this;
    }
    /**
     * Get dateOfBirth value
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->dateOfBirth;
    }
    /**
     * Set dateOfBirth value
     * @param string $dateOfBirth
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public function setDateOfBirth($dateOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfBirth) && !is_string($dateOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateOfBirth)), __LINE__);
        }
        $this->dateOfBirth = $dateOfBirth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\DriverDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
