<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for driver StructType
 * @subpackage Structs
 */
class Driver extends AbstractStructBase
{
    /**
     * The primaryDriver
     * @var string
     */
    public $primaryDriver;
    /**
     * The driverId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $driverId;
    /**
     * The driverDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\DriverDetails
     */
    public $driverDetails;
    /**
     * Constructor method for driver
     * @uses Driver::setPrimaryDriver()
     * @uses Driver::setDriverId()
     * @uses Driver::setDriverDetails()
     * @param string $primaryDriver
     * @param string $driverId
     * @param \GreenwayDirectService\StructType\DriverDetails $driverDetails
     */
    public function __construct($primaryDriver = null, $driverId = null, \GreenwayDirectService\StructType\DriverDetails $driverDetails = null)
    {
        $this
            ->setPrimaryDriver($primaryDriver)
            ->setDriverId($driverId)
            ->setDriverDetails($driverDetails);
    }
    /**
     * Get primaryDriver value
     * @return string|null
     */
    public function getPrimaryDriver()
    {
        return $this->primaryDriver;
    }
    /**
     * Set primaryDriver value
     * @uses \GreenwayDirectService\EnumType\YorN::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\YorN::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $primaryDriver
     * @return \GreenwayDirectService\StructType\Driver
     */
    public function setPrimaryDriver($primaryDriver = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\YorN::valueIsValid($primaryDriver)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $primaryDriver, implode(', ', \GreenwayDirectService\EnumType\YorN::getValidValues())), __LINE__);
        }
        $this->primaryDriver = $primaryDriver;
        return $this;
    }
    /**
     * Get driverId value
     * @return string|null
     */
    public function getDriverId()
    {
        return $this->driverId;
    }
    /**
     * Set driverId value
     * @param string $driverId
     * @return \GreenwayDirectService\StructType\Driver
     */
    public function setDriverId($driverId = null)
    {
        // validation for constraint: string
        if (!is_null($driverId) && !is_string($driverId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($driverId)), __LINE__);
        }
        $this->driverId = $driverId;
        return $this;
    }
    /**
     * Get driverDetails value
     * @return \GreenwayDirectService\StructType\DriverDetails|null
     */
    public function getDriverDetails()
    {
        return $this->driverDetails;
    }
    /**
     * Set driverDetails value
     * @param \GreenwayDirectService\StructType\DriverDetails $driverDetails
     * @return \GreenwayDirectService\StructType\Driver
     */
    public function setDriverDetails(\GreenwayDirectService\StructType\DriverDetails $driverDetails = null)
    {
        $this->driverDetails = $driverDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Driver
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
