<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cardDetails StructType
 * @subpackage Structs
 */
class CardDetails extends AbstractStructBase
{
    /**
     * The cardType
     * @var string
     */
    public $cardType;
    /**
     * The cardNumber
     * @var string
     */
    public $cardNumber;
    /**
     * The expiryDate
     * @var string
     */
    public $expiryDate;
    /**
     * The holderName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $holderName;
    /**
     * Constructor method for cardDetails
     * @uses CardDetails::setCardType()
     * @uses CardDetails::setCardNumber()
     * @uses CardDetails::setExpiryDate()
     * @uses CardDetails::setHolderName()
     * @param string $cardType
     * @param string $cardNumber
     * @param string $expiryDate
     * @param string $holderName
     */
    public function __construct($cardType = null, $cardNumber = null, $expiryDate = null, $holderName = null)
    {
        $this
            ->setCardType($cardType)
            ->setCardNumber($cardNumber)
            ->setExpiryDate($expiryDate)
            ->setHolderName($holderName);
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \GreenwayDirectService\StructType\CardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->cardNumber;
    }
    /**
     * Set cardNumber value
     * @param string $cardNumber
     * @return \GreenwayDirectService\StructType\CardDetails
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->cardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get expiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->expiryDate;
    }
    /**
     * Set expiryDate value
     * @param string $expiryDate
     * @return \GreenwayDirectService\StructType\CardDetails
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expiryDate)), __LINE__);
        }
        $this->expiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get holderName value
     * @return string|null
     */
    public function getHolderName()
    {
        return $this->holderName;
    }
    /**
     * Set holderName value
     * @param string $holderName
     * @return \GreenwayDirectService\StructType\CardDetails
     */
    public function setHolderName($holderName = null)
    {
        // validation for constraint: string
        if (!is_null($holderName) && !is_string($holderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($holderName)), __LINE__);
        }
        $this->holderName = $holderName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\CardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
