<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cancelReservationInfo StructType
 * Meta informations extracted from the WSDL
 * - type: tns:cancelReservationInfo
 * @subpackage Structs
 */
class CancelReservationInfo extends AbstractStructBase
{
    /**
     * The authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\Authentication
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reservationNumber;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\ServiceError[]
     */
    public $error;
    /**
     * Constructor method for cancelReservationInfo
     * @uses CancelReservationInfo::setAuthentication()
     * @uses CancelReservationInfo::setReservationNumber()
     * @uses CancelReservationInfo::setError()
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @param string $reservationNumber
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     */
    public function __construct(\GreenwayDirectService\StructType\Authentication $authentication = null, $reservationNumber = null, array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setAuthentication(\GreenwayDirectService\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param string $reservationNumber
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayDirectService\StructType\ServiceError[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function setError(array $error = array())
    {
        foreach ($error as $cancelReservationInfoErrorItem) {
            // validation for constraint: itemType
            if (!$cancelReservationInfoErrorItem instanceof \GreenwayDirectService\StructType\ServiceError) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($cancelReservationInfoErrorItem) ? get_class($cancelReservationInfoErrorItem) : gettype($cancelReservationInfoErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError $item
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public function addToError(\GreenwayDirectService\StructType\ServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ServiceError) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\CancelReservationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
