<?php

namespace GreenwayDirectService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Amend ServiceType
 * @subpackage Services
 */
class Amend extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named amendOffhire
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\AmendOffhire $parameters
     * @return \GreenwayDirectService\StructType\AmendOffhireResponse|bool
     */
    public function amendOffhire(\GreenwayDirectService\StructType\AmendOffhire $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendOffhire($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named amendReservation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GreenwayDirectService\StructType\AmendReservation $parameters
     * @return \GreenwayDirectService\StructType\AmendReservationResponse|bool
     */
    public function amendReservation(\GreenwayDirectService\StructType\AmendReservation $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->amendReservation($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GreenwayDirectService\StructType\AmendOffhireResponse|\GreenwayDirectService\StructType\AmendReservationResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
