<?php

namespace GreenwayDirectService;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'amendOffhire' => '\\GreenwayDirectService\\StructType\\AmendOffhire',
            'offhire' => '\\GreenwayDirectService\\StructType\\Offhire',
            'authentication' => '\\GreenwayDirectService\\StructType\\Authentication',
            'whenAndWhereDetails' => '\\GreenwayDirectService\\StructType\\WhenAndWhereDetails',
            'rentalAddress' => '\\GreenwayDirectService\\StructType\\RentalAddress',
            'phoneNumber' => '\\GreenwayDirectService\\StructType\\PhoneNumber',
            'instructions' => '\\GreenwayDirectService\\StructType\\Instructions',
            'serviceError' => '\\GreenwayDirectService\\StructType\\ServiceError',
            'amendOffhireResponse' => '\\GreenwayDirectService\\StructType\\AmendOffhireResponse',
            'amendReservation' => '\\GreenwayDirectService\\StructType\\AmendReservation',
            'reservation' => '\\GreenwayDirectService\\StructType\\Reservation',
            'driver' => '\\GreenwayDirectService\\StructType\\Driver',
            'driverDetails' => '\\GreenwayDirectService\\StructType\\DriverDetails',
            'licence' => '\\GreenwayDirectService\\StructType\\Licence',
            'payment' => '\\GreenwayDirectService\\StructType\\Payment',
            'cardDetails' => '\\GreenwayDirectService\\StructType\\CardDetails',
            'customerReference' => '\\GreenwayDirectService\\StructType\\CustomerReference',
            'equipment' => '\\GreenwayDirectService\\StructType\\Equipment',
            'charges' => '\\GreenwayDirectService\\StructType\\Charges',
            'amendReservationResponse' => '\\GreenwayDirectService\\StructType\\AmendReservationResponse',
            'cancelReservation' => '\\GreenwayDirectService\\StructType\\CancelReservation',
            'cancelReservationInfo' => '\\GreenwayDirectService\\StructType\\CancelReservationInfo',
            'cancelReservationResponse' => '\\GreenwayDirectService\\StructType\\CancelReservationResponse',
            'newReservation' => '\\GreenwayDirectService\\StructType\\NewReservation',
            'newReservationResponse' => '\\GreenwayDirectService\\StructType\\NewReservationResponse',
            'getQuote' => '\\GreenwayDirectService\\StructType\\GetQuote',
            'rates' => '\\GreenwayDirectService\\StructType\\Rates',
            'specialCharges' => '\\GreenwayDirectService\\StructType\\SpecialCharges',
            'getQuoteResponse' => '\\GreenwayDirectService\\StructType\\GetQuoteResponse',
        );
    }
}
