<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for reservation StructType
 * @subpackage Structs
 */
class Reservation extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayDirectService\StructType\Authentication
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reservationNumber;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The contractId
     * @var string
     */
    public $contractId;
    /**
     * The modelRequested
     * @var string
     */
    public $modelRequested;
    /**
     * The iataNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $iataNumber;
    /**
     * The flightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $flightNumber;
    /**
     * The contactTelNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactTelNo;
    /**
     * The contactName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $contactName;
    /**
     * The start
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $start;
    /**
     * The end
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The driver
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \GreenwayDirectService\StructType\Driver[]
     */
    public $driver;
    /**
     * The payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\Payment[]
     */
    public $payment;
    /**
     * The customerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\CustomerReference[]
     */
    public $customerReference;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $note;
    /**
     * The equipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\Equipment[]
     */
    public $equipment;
    /**
     * The charges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\Charges[]
     */
    public $charges;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\ServiceError[]
     */
    public $error;
    /**
     * Constructor method for reservation
     * @uses Reservation::setAuthentication()
     * @uses Reservation::setReservationNumber()
     * @uses Reservation::setStatus()
     * @uses Reservation::setContractId()
     * @uses Reservation::setModelRequested()
     * @uses Reservation::setIataNumber()
     * @uses Reservation::setFlightNumber()
     * @uses Reservation::setContactTelNo()
     * @uses Reservation::setContactName()
     * @uses Reservation::setStart()
     * @uses Reservation::setEnd()
     * @uses Reservation::setDriver()
     * @uses Reservation::setPayment()
     * @uses Reservation::setCustomerReference()
     * @uses Reservation::setNote()
     * @uses Reservation::setEquipment()
     * @uses Reservation::setCharges()
     * @uses Reservation::setError()
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @param string $reservationNumber
     * @param string $status
     * @param string $contractId
     * @param string $modelRequested
     * @param string $iataNumber
     * @param string $flightNumber
     * @param string $contactTelNo
     * @param string $contactName
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @param \GreenwayDirectService\StructType\Driver[] $driver
     * @param \GreenwayDirectService\StructType\Payment[] $payment
     * @param \GreenwayDirectService\StructType\CustomerReference[] $customerReference
     * @param string[] $note
     * @param \GreenwayDirectService\StructType\Equipment[] $equipment
     * @param \GreenwayDirectService\StructType\Charges[] $charges
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     */
    public function __construct(\GreenwayDirectService\StructType\Authentication $authentication = null, $reservationNumber = null, $status = null, $contractId = null, $modelRequested = null, $iataNumber = null, $flightNumber = null, $contactTelNo = null, $contactName = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $start = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $end = null, array $driver = array(), array $payment = array(), array $customerReference = array(), array $note = array(), array $equipment = array(), array $charges = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setStatus($status)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setIataNumber($iataNumber)
            ->setFlightNumber($flightNumber)
            ->setContactTelNo($contactTelNo)
            ->setContactName($contactName)
            ->setStart($start)
            ->setEnd($end)
            ->setDriver($driver)
            ->setPayment($payment)
            ->setCustomerReference($customerReference)
            ->setNote($note)
            ->setEquipment($equipment)
            ->setCharges($charges)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setAuthentication(\GreenwayDirectService\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param string $reservationNumber
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \GreenwayDirectService\EnumType\ReservationStatus::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\ReservationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\ReservationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \GreenwayDirectService\EnumType\ReservationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get contractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param string $contractId
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return string|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param string $modelRequested
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setModelRequested($modelRequested = null)
    {
        // validation for constraint: string
        if (!is_null($modelRequested) && !is_string($modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelRequested)), __LINE__);
        }
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get iataNumber value
     * @return string|null
     */
    public function getIataNumber()
    {
        return $this->iataNumber;
    }
    /**
     * Set iataNumber value
     * @param string $iataNumber
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setIataNumber($iataNumber = null)
    {
        // validation for constraint: string
        if (!is_null($iataNumber) && !is_string($iataNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iataNumber)), __LINE__);
        }
        $this->iataNumber = $iataNumber;
        return $this;
    }
    /**
     * Get flightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->flightNumber;
    }
    /**
     * Set flightNumber value
     * @param string $flightNumber
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightNumber)), __LINE__);
        }
        $this->flightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get contactTelNo value
     * @return string|null
     */
    public function getContactTelNo()
    {
        return $this->contactTelNo;
    }
    /**
     * Set contactTelNo value
     * @param string $contactTelNo
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setContactTelNo($contactTelNo = null)
    {
        // validation for constraint: string
        if (!is_null($contactTelNo) && !is_string($contactTelNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactTelNo)), __LINE__);
        }
        $this->contactTelNo = $contactTelNo;
        return $this;
    }
    /**
     * Get contactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->contactName;
    }
    /**
     * Set contactName value
     * @param string $contactName
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->contactName = $contactName;
        return $this;
    }
    /**
     * Get start value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setStart(\GreenwayDirectService\StructType\WhenAndWhereDetails $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setEnd(\GreenwayDirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get driver value
     * @return \GreenwayDirectService\StructType\Driver[]|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Driver[] $driver
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setDriver(array $driver = array())
    {
        foreach ($driver as $reservationDriverItem) {
            // validation for constraint: itemType
            if (!$reservationDriverItem instanceof \GreenwayDirectService\StructType\Driver) {
                throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayDirectService\StructType\Driver, "%s" given', is_object($reservationDriverItem) ? get_class($reservationDriverItem) : gettype($reservationDriverItem)), __LINE__);
            }
        }
        $this->driver = $driver;
        return $this;
    }
    /**
     * Add item to driver value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Driver $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToDriver(\GreenwayDirectService\StructType\Driver $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\Driver) {
            throw new \InvalidArgumentException(sprintf('The driver property can only contain items of \GreenwayDirectService\StructType\Driver, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->driver[] = $item;
        return $this;
    }
    /**
     * Get payment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\Payment[]|null
     */
    public function getPayment()
    {
        return isset($this->payment) ? $this->payment : null;
    }
    /**
     * Set payment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Payment[] $payment
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setPayment(array $payment = array())
    {
        foreach ($payment as $reservationPaymentItem) {
            // validation for constraint: itemType
            if (!$reservationPaymentItem instanceof \GreenwayDirectService\StructType\Payment) {
                throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayDirectService\StructType\Payment, "%s" given', is_object($reservationPaymentItem) ? get_class($reservationPaymentItem) : gettype($reservationPaymentItem)), __LINE__);
            }
        }
        if (is_null($payment) || (is_array($payment) && empty($payment))) {
            unset($this->payment);
        } else {
            $this->payment = $payment;
        }
        return $this;
    }
    /**
     * Add item to payment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Payment $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToPayment(\GreenwayDirectService\StructType\Payment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\Payment) {
            throw new \InvalidArgumentException(sprintf('The payment property can only contain items of \GreenwayDirectService\StructType\Payment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payment[] = $item;
        return $this;
    }
    /**
     * Get customerReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\CustomerReference[]|null
     */
    public function getCustomerReference()
    {
        return isset($this->customerReference) ? $this->customerReference : null;
    }
    /**
     * Set customerReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\CustomerReference[] $customerReference
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setCustomerReference(array $customerReference = array())
    {
        foreach ($customerReference as $reservationCustomerReferenceItem) {
            // validation for constraint: itemType
            if (!$reservationCustomerReferenceItem instanceof \GreenwayDirectService\StructType\CustomerReference) {
                throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayDirectService\StructType\CustomerReference, "%s" given', is_object($reservationCustomerReferenceItem) ? get_class($reservationCustomerReferenceItem) : gettype($reservationCustomerReferenceItem)), __LINE__);
            }
        }
        if (is_null($customerReference) || (is_array($customerReference) && empty($customerReference))) {
            unset($this->customerReference);
        } else {
            $this->customerReference = $customerReference;
        }
        return $this;
    }
    /**
     * Add item to customerReference value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\CustomerReference $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToCustomerReference(\GreenwayDirectService\StructType\CustomerReference $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\CustomerReference) {
            throw new \InvalidArgumentException(sprintf('The customerReference property can only contain items of \GreenwayDirectService\StructType\CustomerReference, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->customerReference[] = $item;
        return $this;
    }
    /**
     * Get note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getNote()
    {
        return isset($this->note) ? $this->note : null;
    }
    /**
     * Set note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $reservationNoteItem) {
            // validation for constraint: itemType
            if (!is_string($reservationNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($reservationNoteItem) ? get_class($reservationNoteItem) : gettype($reservationNoteItem)), __LINE__);
            }
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->note);
        } else {
            $this->note = $note;
        }
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToNote($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get equipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\Equipment[]|null
     */
    public function getEquipment()
    {
        return isset($this->equipment) ? $this->equipment : null;
    }
    /**
     * Set equipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Equipment[] $equipment
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setEquipment(array $equipment = array())
    {
        foreach ($equipment as $reservationEquipmentItem) {
            // validation for constraint: itemType
            if (!$reservationEquipmentItem instanceof \GreenwayDirectService\StructType\Equipment) {
                throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayDirectService\StructType\Equipment, "%s" given', is_object($reservationEquipmentItem) ? get_class($reservationEquipmentItem) : gettype($reservationEquipmentItem)), __LINE__);
            }
        }
        if (is_null($equipment) || (is_array($equipment) && empty($equipment))) {
            unset($this->equipment);
        } else {
            $this->equipment = $equipment;
        }
        return $this;
    }
    /**
     * Add item to equipment value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Equipment $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToEquipment(\GreenwayDirectService\StructType\Equipment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\Equipment) {
            throw new \InvalidArgumentException(sprintf('The equipment property can only contain items of \GreenwayDirectService\StructType\Equipment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->equipment[] = $item;
        return $this;
    }
    /**
     * Get charges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\Charges[]|null
     */
    public function getCharges()
    {
        return isset($this->charges) ? $this->charges : null;
    }
    /**
     * Set charges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Charges[] $charges
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setCharges(array $charges = array())
    {
        foreach ($charges as $reservationChargesItem) {
            // validation for constraint: itemType
            if (!$reservationChargesItem instanceof \GreenwayDirectService\StructType\Charges) {
                throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayDirectService\StructType\Charges, "%s" given', is_object($reservationChargesItem) ? get_class($reservationChargesItem) : gettype($reservationChargesItem)), __LINE__);
            }
        }
        if (is_null($charges) || (is_array($charges) && empty($charges))) {
            unset($this->charges);
        } else {
            $this->charges = $charges;
        }
        return $this;
    }
    /**
     * Add item to charges value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Charges $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToCharges(\GreenwayDirectService\StructType\Charges $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\Charges) {
            throw new \InvalidArgumentException(sprintf('The charges property can only contain items of \GreenwayDirectService\StructType\Charges, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charges[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayDirectService\StructType\ServiceError[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function setError(array $error = array())
    {
        foreach ($error as $reservationErrorItem) {
            // validation for constraint: itemType
            if (!$reservationErrorItem instanceof \GreenwayDirectService\StructType\ServiceError) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($reservationErrorItem) ? get_class($reservationErrorItem) : gettype($reservationErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError $item
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public function addToError(\GreenwayDirectService\StructType\ServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ServiceError) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Reservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
