<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for rates StructType
 * Meta informations extracted from the WSDL
 * - type: tns:rates
 * @subpackage Structs
 */
class Rates extends AbstractStructBase
{
    /**
     * The authentication
     * @var \GreenwayDirectService\StructType\Authentication
     */
    public $authentication;
    /**
     * The contractId
     * @var string
     */
    public $contractId;
    /**
     * The modelRequested
     * @var string
     */
    public $modelRequested;
    /**
     * The start
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $start;
    /**
     * The end
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The specialCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\SpecialCharges[]
     */
    public $specialCharges;
    /**
     * The netCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $netCharge;
    /**
     * The totalVat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $totalVat;
    /**
     * The grossCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $grossCharge;
    /**
     * The noOfLines
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noOfLines;
    /**
     * The errorNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorNo;
    /**
     * The errorMessage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $errorMessage;
    /**
     * The charge
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\Charges[]
     */
    public $charge;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GreenwayDirectService\StructType\ServiceError[]
     */
    public $error;
    /**
     * Constructor method for rates
     * @uses Rates::setAuthentication()
     * @uses Rates::setContractId()
     * @uses Rates::setModelRequested()
     * @uses Rates::setStart()
     * @uses Rates::setEnd()
     * @uses Rates::setSpecialCharges()
     * @uses Rates::setNetCharge()
     * @uses Rates::setTotalVat()
     * @uses Rates::setGrossCharge()
     * @uses Rates::setNoOfLines()
     * @uses Rates::setErrorNo()
     * @uses Rates::setErrorMessage()
     * @uses Rates::setCharge()
     * @uses Rates::setError()
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @param string $contractId
     * @param string $modelRequested
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @param \GreenwayDirectService\StructType\SpecialCharges[] $specialCharges
     * @param string $netCharge
     * @param string $totalVat
     * @param string $grossCharge
     * @param string $noOfLines
     * @param string $errorNo
     * @param string $errorMessage
     * @param \GreenwayDirectService\StructType\Charges[] $charge
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     */
    public function __construct(\GreenwayDirectService\StructType\Authentication $authentication = null, $contractId = null, $modelRequested = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $start = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $end = null, array $specialCharges = array(), $netCharge = null, $totalVat = null, $grossCharge = null, $noOfLines = null, $errorNo = null, $errorMessage = null, array $charge = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setContractId($contractId)
            ->setModelRequested($modelRequested)
            ->setStart($start)
            ->setEnd($end)
            ->setSpecialCharges($specialCharges)
            ->setNetCharge($netCharge)
            ->setTotalVat($totalVat)
            ->setGrossCharge($grossCharge)
            ->setNoOfLines($noOfLines)
            ->setErrorNo($errorNo)
            ->setErrorMessage($errorMessage)
            ->setCharge($charge)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setAuthentication(\GreenwayDirectService\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get contractId value
     * @return string|null
     */
    public function getContractId()
    {
        return $this->contractId;
    }
    /**
     * Set contractId value
     * @param string $contractId
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setContractId($contractId = null)
    {
        // validation for constraint: string
        if (!is_null($contractId) && !is_string($contractId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contractId)), __LINE__);
        }
        $this->contractId = $contractId;
        return $this;
    }
    /**
     * Get modelRequested value
     * @return string|null
     */
    public function getModelRequested()
    {
        return $this->modelRequested;
    }
    /**
     * Set modelRequested value
     * @param string $modelRequested
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setModelRequested($modelRequested = null)
    {
        // validation for constraint: string
        if (!is_null($modelRequested) && !is_string($modelRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelRequested)), __LINE__);
        }
        $this->modelRequested = $modelRequested;
        return $this;
    }
    /**
     * Get start value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $start
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setStart(\GreenwayDirectService\StructType\WhenAndWhereDetails $start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setEnd(\GreenwayDirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get specialCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\SpecialCharges[]|null
     */
    public function getSpecialCharges()
    {
        return isset($this->specialCharges) ? $this->specialCharges : null;
    }
    /**
     * Set specialCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\SpecialCharges[] $specialCharges
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setSpecialCharges(array $specialCharges = array())
    {
        foreach ($specialCharges as $ratesSpecialChargesItem) {
            // validation for constraint: itemType
            if (!$ratesSpecialChargesItem instanceof \GreenwayDirectService\StructType\SpecialCharges) {
                throw new \InvalidArgumentException(sprintf('The specialCharges property can only contain items of \GreenwayDirectService\StructType\SpecialCharges, "%s" given', is_object($ratesSpecialChargesItem) ? get_class($ratesSpecialChargesItem) : gettype($ratesSpecialChargesItem)), __LINE__);
            }
        }
        if (is_null($specialCharges) || (is_array($specialCharges) && empty($specialCharges))) {
            unset($this->specialCharges);
        } else {
            $this->specialCharges = $specialCharges;
        }
        return $this;
    }
    /**
     * Add item to specialCharges value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\SpecialCharges $item
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function addToSpecialCharges(\GreenwayDirectService\StructType\SpecialCharges $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\SpecialCharges) {
            throw new \InvalidArgumentException(sprintf('The specialCharges property can only contain items of \GreenwayDirectService\StructType\SpecialCharges, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->specialCharges[] = $item;
        return $this;
    }
    /**
     * Get netCharge value
     * @return string|null
     */
    public function getNetCharge()
    {
        return $this->netCharge;
    }
    /**
     * Set netCharge value
     * @param string $netCharge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setNetCharge($netCharge = null)
    {
        // validation for constraint: string
        if (!is_null($netCharge) && !is_string($netCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($netCharge)), __LINE__);
        }
        $this->netCharge = $netCharge;
        return $this;
    }
    /**
     * Get totalVat value
     * @return string|null
     */
    public function getTotalVat()
    {
        return $this->totalVat;
    }
    /**
     * Set totalVat value
     * @param string $totalVat
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setTotalVat($totalVat = null)
    {
        // validation for constraint: string
        if (!is_null($totalVat) && !is_string($totalVat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalVat)), __LINE__);
        }
        $this->totalVat = $totalVat;
        return $this;
    }
    /**
     * Get grossCharge value
     * @return string|null
     */
    public function getGrossCharge()
    {
        return $this->grossCharge;
    }
    /**
     * Set grossCharge value
     * @param string $grossCharge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setGrossCharge($grossCharge = null)
    {
        // validation for constraint: string
        if (!is_null($grossCharge) && !is_string($grossCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($grossCharge)), __LINE__);
        }
        $this->grossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get noOfLines value
     * @return string|null
     */
    public function getNoOfLines()
    {
        return $this->noOfLines;
    }
    /**
     * Set noOfLines value
     * @param string $noOfLines
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setNoOfLines($noOfLines = null)
    {
        // validation for constraint: string
        if (!is_null($noOfLines) && !is_string($noOfLines)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfLines)), __LINE__);
        }
        $this->noOfLines = $noOfLines;
        return $this;
    }
    /**
     * Get errorNo value
     * @return string|null
     */
    public function getErrorNo()
    {
        return $this->errorNo;
    }
    /**
     * Set errorNo value
     * @param string $errorNo
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setErrorNo($errorNo = null)
    {
        // validation for constraint: string
        if (!is_null($errorNo) && !is_string($errorNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorNo)), __LINE__);
        }
        $this->errorNo = $errorNo;
        return $this;
    }
    /**
     * Get errorMessage value
     * @return string|null
     */
    public function getErrorMessage()
    {
        return $this->errorMessage;
    }
    /**
     * Set errorMessage value
     * @param string $errorMessage
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($errorMessage)), __LINE__);
        }
        $this->errorMessage = $errorMessage;
        return $this;
    }
    /**
     * Get charge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\Charges[]|null
     */
    public function getCharge()
    {
        return isset($this->charge) ? $this->charge : null;
    }
    /**
     * Set charge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Charges[] $charge
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setCharge(array $charge = array())
    {
        foreach ($charge as $ratesChargeItem) {
            // validation for constraint: itemType
            if (!$ratesChargeItem instanceof \GreenwayDirectService\StructType\Charges) {
                throw new \InvalidArgumentException(sprintf('The charge property can only contain items of \GreenwayDirectService\StructType\Charges, "%s" given', is_object($ratesChargeItem) ? get_class($ratesChargeItem) : gettype($ratesChargeItem)), __LINE__);
            }
        }
        if (is_null($charge) || (is_array($charge) && empty($charge))) {
            unset($this->charge);
        } else {
            $this->charge = $charge;
        }
        return $this;
    }
    /**
     * Add item to charge value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\Charges $item
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function addToCharge(\GreenwayDirectService\StructType\Charges $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\Charges) {
            throw new \InvalidArgumentException(sprintf('The charge property can only contain items of \GreenwayDirectService\StructType\Charges, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->charge[] = $item;
        return $this;
    }
    /**
     * Get error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GreenwayDirectService\StructType\ServiceError[]|null
     */
    public function getError()
    {
        return isset($this->error) ? $this->error : null;
    }
    /**
     * Set error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function setError(array $error = array())
    {
        foreach ($error as $ratesErrorItem) {
            // validation for constraint: itemType
            if (!$ratesErrorItem instanceof \GreenwayDirectService\StructType\ServiceError) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($ratesErrorItem) ? get_class($ratesErrorItem) : gettype($ratesErrorItem)), __LINE__);
            }
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->error);
        } else {
            $this->error = $error;
        }
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError $item
     * @return \GreenwayDirectService\StructType\Rates
     */
    public function addToError(\GreenwayDirectService\StructType\ServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ServiceError) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Rates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
