<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for payment StructType
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The methodOfPayment
     * @var string
     */
    public $methodOfPayment;
    /**
     * The creditOrDebitCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\CardDetails
     */
    public $creditOrDebitCard;
    /**
     * The businessAccount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $businessAccount;
    /**
     * The chargeCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $chargeCard;
    /**
     * Constructor method for payment
     * @uses Payment::setMethodOfPayment()
     * @uses Payment::setCreditOrDebitCard()
     * @uses Payment::setBusinessAccount()
     * @uses Payment::setChargeCard()
     * @param string $methodOfPayment
     * @param \GreenwayDirectService\StructType\CardDetails $creditOrDebitCard
     * @param string $businessAccount
     * @param string $chargeCard
     */
    public function __construct($methodOfPayment = null, \GreenwayDirectService\StructType\CardDetails $creditOrDebitCard = null, $businessAccount = null, $chargeCard = null)
    {
        $this
            ->setMethodOfPayment($methodOfPayment)
            ->setCreditOrDebitCard($creditOrDebitCard)
            ->setBusinessAccount($businessAccount)
            ->setChargeCard($chargeCard);
    }
    /**
     * Get methodOfPayment value
     * @return string|null
     */
    public function getMethodOfPayment()
    {
        return $this->methodOfPayment;
    }
    /**
     * Set methodOfPayment value
     * @param string $methodOfPayment
     * @return \GreenwayDirectService\StructType\Payment
     */
    public function setMethodOfPayment($methodOfPayment = null)
    {
        // validation for constraint: string
        if (!is_null($methodOfPayment) && !is_string($methodOfPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($methodOfPayment)), __LINE__);
        }
        $this->methodOfPayment = $methodOfPayment;
        return $this;
    }
    /**
     * Get creditOrDebitCard value
     * @return \GreenwayDirectService\StructType\CardDetails|null
     */
    public function getCreditOrDebitCard()
    {
        return $this->creditOrDebitCard;
    }
    /**
     * Set creditOrDebitCard value
     * @param \GreenwayDirectService\StructType\CardDetails $creditOrDebitCard
     * @return \GreenwayDirectService\StructType\Payment
     */
    public function setCreditOrDebitCard(\GreenwayDirectService\StructType\CardDetails $creditOrDebitCard = null)
    {
        $this->creditOrDebitCard = $creditOrDebitCard;
        return $this;
    }
    /**
     * Get businessAccount value
     * @return string|null
     */
    public function getBusinessAccount()
    {
        return $this->businessAccount;
    }
    /**
     * Set businessAccount value
     * @param string $businessAccount
     * @return \GreenwayDirectService\StructType\Payment
     */
    public function setBusinessAccount($businessAccount = null)
    {
        // validation for constraint: string
        if (!is_null($businessAccount) && !is_string($businessAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($businessAccount)), __LINE__);
        }
        $this->businessAccount = $businessAccount;
        return $this;
    }
    /**
     * Get chargeCard value
     * @return string|null
     */
    public function getChargeCard()
    {
        return $this->chargeCard;
    }
    /**
     * Set chargeCard value
     * @param string $chargeCard
     * @return \GreenwayDirectService\StructType\Payment
     */
    public function setChargeCard($chargeCard = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCard) && !is_string($chargeCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCard)), __LINE__);
        }
        $this->chargeCard = $chargeCard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
