<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for offhire StructType
 * Meta informations extracted from the WSDL
 * - type: tns:offhire
 * @subpackage Structs
 */
class Offhire extends AbstractStructBase
{
    /**
     * The authentication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\Authentication
     */
    public $authentication;
    /**
     * The reservationNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $reservationNumber;
    /**
     * The rentalNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rentalNumber;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\WhenAndWhereDetails
     */
    public $end;
    /**
     * The note
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $note;
    /**
     * The error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GreenwayDirectService\StructType\ServiceError[]
     */
    public $error;
    /**
     * Constructor method for offhire
     * @uses Offhire::setAuthentication()
     * @uses Offhire::setReservationNumber()
     * @uses Offhire::setRentalNumber()
     * @uses Offhire::setEnd()
     * @uses Offhire::setNote()
     * @uses Offhire::setError()
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @param string $reservationNumber
     * @param string $rentalNumber
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @param string[] $note
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     */
    public function __construct(\GreenwayDirectService\StructType\Authentication $authentication = null, $reservationNumber = null, $rentalNumber = null, \GreenwayDirectService\StructType\WhenAndWhereDetails $end = null, array $note = array(), array $error = array())
    {
        $this
            ->setAuthentication($authentication)
            ->setReservationNumber($reservationNumber)
            ->setRentalNumber($rentalNumber)
            ->setEnd($end)
            ->setNote($note)
            ->setError($error);
    }
    /**
     * Get authentication value
     * @return \GreenwayDirectService\StructType\Authentication|null
     */
    public function getAuthentication()
    {
        return $this->authentication;
    }
    /**
     * Set authentication value
     * @param \GreenwayDirectService\StructType\Authentication $authentication
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setAuthentication(\GreenwayDirectService\StructType\Authentication $authentication = null)
    {
        $this->authentication = $authentication;
        return $this;
    }
    /**
     * Get reservationNumber value
     * @return string|null
     */
    public function getReservationNumber()
    {
        return $this->reservationNumber;
    }
    /**
     * Set reservationNumber value
     * @param string $reservationNumber
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setReservationNumber($reservationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($reservationNumber) && !is_string($reservationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reservationNumber)), __LINE__);
        }
        $this->reservationNumber = $reservationNumber;
        return $this;
    }
    /**
     * Get rentalNumber value
     * @return string|null
     */
    public function getRentalNumber()
    {
        return $this->rentalNumber;
    }
    /**
     * Set rentalNumber value
     * @param string $rentalNumber
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setRentalNumber($rentalNumber = null)
    {
        // validation for constraint: string
        if (!is_null($rentalNumber) && !is_string($rentalNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rentalNumber)), __LINE__);
        }
        $this->rentalNumber = $rentalNumber;
        return $this;
    }
    /**
     * Get end value
     * @return \GreenwayDirectService\StructType\WhenAndWhereDetails|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param \GreenwayDirectService\StructType\WhenAndWhereDetails $end
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setEnd(\GreenwayDirectService\StructType\WhenAndWhereDetails $end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get note value
     * @return string[]|null
     */
    public function getNote()
    {
        return $this->note;
    }
    /**
     * Set note value
     * @throws \InvalidArgumentException
     * @param string[] $note
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setNote(array $note = array())
    {
        foreach ($note as $offhireNoteItem) {
            // validation for constraint: itemType
            if (!is_string($offhireNoteItem)) {
                throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($offhireNoteItem) ? get_class($offhireNoteItem) : gettype($offhireNoteItem)), __LINE__);
            }
        }
        $this->note = $note;
        return $this;
    }
    /**
     * Add item to note value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function addToNote($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The note property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->note[] = $item;
        return $this;
    }
    /**
     * Get error value
     * @return \GreenwayDirectService\StructType\ServiceError[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError[] $error
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function setError(array $error = array())
    {
        foreach ($error as $offhireErrorItem) {
            // validation for constraint: itemType
            if (!$offhireErrorItem instanceof \GreenwayDirectService\StructType\ServiceError) {
                throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($offhireErrorItem) ? get_class($offhireErrorItem) : gettype($offhireErrorItem)), __LINE__);
            }
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \GreenwayDirectService\StructType\ServiceError $item
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public function addToError(\GreenwayDirectService\StructType\ServiceError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GreenwayDirectService\StructType\ServiceError) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of \GreenwayDirectService\StructType\ServiceError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Offhire
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
