<?php

namespace GreenwayDirectService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for charges StructType
 * @subpackage Structs
 */
class Charges extends AbstractStructBase
{
    /**
     * The chargeType
     * @var string
     */
    public $chargeType;
    /**
     * The description
     * @var string
     */
    public $description;
    /**
     * The unitsCharged
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $unitsCharged;
    /**
     * The chargeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $chargeRate;
    /**
     * The netCharge
     * @var float
     */
    public $netCharge;
    /**
     * The taxAmount
     * @var float
     */
    public $taxAmount;
    /**
     * The grossCharge
     * @var float
     */
    public $grossCharge;
    /**
     * The whoPays
     * @var string
     */
    public $whoPays;
    /**
     * The chargeDef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $chargeDef;
    /**
     * The chargeTypeDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $chargeTypeDesc;
    /**
     * The includedInCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $includedInCharge;
    /**
     * The includedInChargeDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $includedInChargeDesc;
    /**
     * The unitType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $unitType;
    /**
     * The rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $rate;
    /**
     * The noOfUnits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $noOfUnits;
    /**
     * The deposit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deposit;
    /**
     * The charge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $charge;
    /**
     * The vatCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vatCode;
    /**
     * The totalCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $totalCharge;
    /**
     * The includeDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $includeDeposit;
    /**
     * The tpbAccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $tpbAccountNo;
    /**
     * Constructor method for charges
     * @uses Charges::setChargeType()
     * @uses Charges::setDescription()
     * @uses Charges::setUnitsCharged()
     * @uses Charges::setChargeRate()
     * @uses Charges::setNetCharge()
     * @uses Charges::setTaxAmount()
     * @uses Charges::setGrossCharge()
     * @uses Charges::setWhoPays()
     * @uses Charges::setChargeDef()
     * @uses Charges::setChargeTypeDesc()
     * @uses Charges::setIncludedInCharge()
     * @uses Charges::setIncludedInChargeDesc()
     * @uses Charges::setUnitType()
     * @uses Charges::setRate()
     * @uses Charges::setNoOfUnits()
     * @uses Charges::setDeposit()
     * @uses Charges::setCharge()
     * @uses Charges::setVatCode()
     * @uses Charges::setTotalCharge()
     * @uses Charges::setIncludeDeposit()
     * @uses Charges::setTpbAccountNo()
     * @param string $chargeType
     * @param string $description
     * @param int $unitsCharged
     * @param float $chargeRate
     * @param float $netCharge
     * @param float $taxAmount
     * @param float $grossCharge
     * @param string $whoPays
     * @param string $chargeDef
     * @param string $chargeTypeDesc
     * @param string $includedInCharge
     * @param string $includedInChargeDesc
     * @param string $unitType
     * @param string $rate
     * @param string $noOfUnits
     * @param string $deposit
     * @param string $charge
     * @param string $vatCode
     * @param string $totalCharge
     * @param string[] $includeDeposit
     * @param string[] $tpbAccountNo
     */
    public function __construct($chargeType = null, $description = null, $unitsCharged = null, $chargeRate = null, $netCharge = null, $taxAmount = null, $grossCharge = null, $whoPays = null, $chargeDef = null, $chargeTypeDesc = null, $includedInCharge = null, $includedInChargeDesc = null, $unitType = null, $rate = null, $noOfUnits = null, $deposit = null, $charge = null, $vatCode = null, $totalCharge = null, array $includeDeposit = array(), array $tpbAccountNo = array())
    {
        $this
            ->setChargeType($chargeType)
            ->setDescription($description)
            ->setUnitsCharged($unitsCharged)
            ->setChargeRate($chargeRate)
            ->setNetCharge($netCharge)
            ->setTaxAmount($taxAmount)
            ->setGrossCharge($grossCharge)
            ->setWhoPays($whoPays)
            ->setChargeDef($chargeDef)
            ->setChargeTypeDesc($chargeTypeDesc)
            ->setIncludedInCharge($includedInCharge)
            ->setIncludedInChargeDesc($includedInChargeDesc)
            ->setUnitType($unitType)
            ->setRate($rate)
            ->setNoOfUnits($noOfUnits)
            ->setDeposit($deposit)
            ->setCharge($charge)
            ->setVatCode($vatCode)
            ->setTotalCharge($totalCharge)
            ->setIncludeDeposit($includeDeposit)
            ->setTpbAccountNo($tpbAccountNo);
    }
    /**
     * Get chargeType value
     * @return string|null
     */
    public function getChargeType()
    {
        return $this->chargeType;
    }
    /**
     * Set chargeType value
     * @param string $chargeType
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: string
        if (!is_null($chargeType) && !is_string($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeType)), __LINE__);
        }
        $this->chargeType = $chargeType;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get unitsCharged value
     * @return int|null
     */
    public function getUnitsCharged()
    {
        return $this->unitsCharged;
    }
    /**
     * Set unitsCharged value
     * @param int $unitsCharged
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setUnitsCharged($unitsCharged = null)
    {
        // validation for constraint: int
        if (!is_null($unitsCharged) && !is_numeric($unitsCharged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitsCharged)), __LINE__);
        }
        $this->unitsCharged = $unitsCharged;
        return $this;
    }
    /**
     * Get chargeRate value
     * @return float|null
     */
    public function getChargeRate()
    {
        return $this->chargeRate;
    }
    /**
     * Set chargeRate value
     * @param float $chargeRate
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setChargeRate($chargeRate = null)
    {
        $this->chargeRate = $chargeRate;
        return $this;
    }
    /**
     * Get netCharge value
     * @return float|null
     */
    public function getNetCharge()
    {
        return $this->netCharge;
    }
    /**
     * Set netCharge value
     * @param float $netCharge
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setNetCharge($netCharge = null)
    {
        $this->netCharge = $netCharge;
        return $this;
    }
    /**
     * Get taxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->taxAmount;
    }
    /**
     * Set taxAmount value
     * @param float $taxAmount
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->taxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get grossCharge value
     * @return float|null
     */
    public function getGrossCharge()
    {
        return $this->grossCharge;
    }
    /**
     * Set grossCharge value
     * @param float $grossCharge
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setGrossCharge($grossCharge = null)
    {
        $this->grossCharge = $grossCharge;
        return $this;
    }
    /**
     * Get whoPays value
     * @return string|null
     */
    public function getWhoPays()
    {
        return $this->whoPays;
    }
    /**
     * Set whoPays value
     * @uses \GreenwayDirectService\EnumType\WhoPays::valueIsValid()
     * @uses \GreenwayDirectService\EnumType\WhoPays::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $whoPays
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setWhoPays($whoPays = null)
    {
        // validation for constraint: enumeration
        if (!\GreenwayDirectService\EnumType\WhoPays::valueIsValid($whoPays)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $whoPays, implode(', ', \GreenwayDirectService\EnumType\WhoPays::getValidValues())), __LINE__);
        }
        $this->whoPays = $whoPays;
        return $this;
    }
    /**
     * Get chargeDef value
     * @return string|null
     */
    public function getChargeDef()
    {
        return $this->chargeDef;
    }
    /**
     * Set chargeDef value
     * @param string $chargeDef
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setChargeDef($chargeDef = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDef) && !is_string($chargeDef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeDef)), __LINE__);
        }
        $this->chargeDef = $chargeDef;
        return $this;
    }
    /**
     * Get chargeTypeDesc value
     * @return string|null
     */
    public function getChargeTypeDesc()
    {
        return $this->chargeTypeDesc;
    }
    /**
     * Set chargeTypeDesc value
     * @param string $chargeTypeDesc
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setChargeTypeDesc($chargeTypeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($chargeTypeDesc) && !is_string($chargeTypeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeTypeDesc)), __LINE__);
        }
        $this->chargeTypeDesc = $chargeTypeDesc;
        return $this;
    }
    /**
     * Get includedInCharge value
     * @return string|null
     */
    public function getIncludedInCharge()
    {
        return $this->includedInCharge;
    }
    /**
     * Set includedInCharge value
     * @param string $includedInCharge
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setIncludedInCharge($includedInCharge = null)
    {
        // validation for constraint: string
        if (!is_null($includedInCharge) && !is_string($includedInCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includedInCharge)), __LINE__);
        }
        $this->includedInCharge = $includedInCharge;
        return $this;
    }
    /**
     * Get includedInChargeDesc value
     * @return string|null
     */
    public function getIncludedInChargeDesc()
    {
        return $this->includedInChargeDesc;
    }
    /**
     * Set includedInChargeDesc value
     * @param string $includedInChargeDesc
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setIncludedInChargeDesc($includedInChargeDesc = null)
    {
        // validation for constraint: string
        if (!is_null($includedInChargeDesc) && !is_string($includedInChargeDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($includedInChargeDesc)), __LINE__);
        }
        $this->includedInChargeDesc = $includedInChargeDesc;
        return $this;
    }
    /**
     * Get unitType value
     * @return string|null
     */
    public function getUnitType()
    {
        return $this->unitType;
    }
    /**
     * Set unitType value
     * @param string $unitType
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setUnitType($unitType = null)
    {
        // validation for constraint: string
        if (!is_null($unitType) && !is_string($unitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitType)), __LINE__);
        }
        $this->unitType = $unitType;
        return $this;
    }
    /**
     * Get rate value
     * @return string|null
     */
    public function getRate()
    {
        return $this->rate;
    }
    /**
     * Set rate value
     * @param string $rate
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setRate($rate = null)
    {
        // validation for constraint: string
        if (!is_null($rate) && !is_string($rate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rate)), __LINE__);
        }
        $this->rate = $rate;
        return $this;
    }
    /**
     * Get noOfUnits value
     * @return string|null
     */
    public function getNoOfUnits()
    {
        return $this->noOfUnits;
    }
    /**
     * Set noOfUnits value
     * @param string $noOfUnits
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setNoOfUnits($noOfUnits = null)
    {
        // validation for constraint: string
        if (!is_null($noOfUnits) && !is_string($noOfUnits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noOfUnits)), __LINE__);
        }
        $this->noOfUnits = $noOfUnits;
        return $this;
    }
    /**
     * Get deposit value
     * @return string|null
     */
    public function getDeposit()
    {
        return $this->deposit;
    }
    /**
     * Set deposit value
     * @param string $deposit
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setDeposit($deposit = null)
    {
        // validation for constraint: string
        if (!is_null($deposit) && !is_string($deposit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($deposit)), __LINE__);
        }
        $this->deposit = $deposit;
        return $this;
    }
    /**
     * Get charge value
     * @return string|null
     */
    public function getCharge()
    {
        return $this->charge;
    }
    /**
     * Set charge value
     * @param string $charge
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setCharge($charge = null)
    {
        // validation for constraint: string
        if (!is_null($charge) && !is_string($charge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($charge)), __LINE__);
        }
        $this->charge = $charge;
        return $this;
    }
    /**
     * Get vatCode value
     * @return string|null
     */
    public function getVatCode()
    {
        return $this->vatCode;
    }
    /**
     * Set vatCode value
     * @param string $vatCode
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setVatCode($vatCode = null)
    {
        // validation for constraint: string
        if (!is_null($vatCode) && !is_string($vatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vatCode)), __LINE__);
        }
        $this->vatCode = $vatCode;
        return $this;
    }
    /**
     * Get totalCharge value
     * @return string|null
     */
    public function getTotalCharge()
    {
        return $this->totalCharge;
    }
    /**
     * Set totalCharge value
     * @param string $totalCharge
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setTotalCharge($totalCharge = null)
    {
        // validation for constraint: string
        if (!is_null($totalCharge) && !is_string($totalCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($totalCharge)), __LINE__);
        }
        $this->totalCharge = $totalCharge;
        return $this;
    }
    /**
     * Get includeDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getIncludeDeposit()
    {
        return isset($this->includeDeposit) ? $this->includeDeposit : null;
    }
    /**
     * Set includeDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $includeDeposit
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setIncludeDeposit(array $includeDeposit = array())
    {
        foreach ($includeDeposit as $chargesIncludeDepositItem) {
            // validation for constraint: itemType
            if (!is_string($chargesIncludeDepositItem)) {
                throw new \InvalidArgumentException(sprintf('The includeDeposit property can only contain items of string, "%s" given', is_object($chargesIncludeDepositItem) ? get_class($chargesIncludeDepositItem) : gettype($chargesIncludeDepositItem)), __LINE__);
            }
        }
        if (is_null($includeDeposit) || (is_array($includeDeposit) && empty($includeDeposit))) {
            unset($this->includeDeposit);
        } else {
            $this->includeDeposit = $includeDeposit;
        }
        return $this;
    }
    /**
     * Add item to includeDeposit value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function addToIncludeDeposit($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The includeDeposit property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->includeDeposit[] = $item;
        return $this;
    }
    /**
     * Get tpbAccountNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getTpbAccountNo()
    {
        return isset($this->tpbAccountNo) ? $this->tpbAccountNo : null;
    }
    /**
     * Set tpbAccountNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $tpbAccountNo
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function setTpbAccountNo(array $tpbAccountNo = array())
    {
        foreach ($tpbAccountNo as $chargesTpbAccountNoItem) {
            // validation for constraint: itemType
            if (!is_string($chargesTpbAccountNoItem)) {
                throw new \InvalidArgumentException(sprintf('The tpbAccountNo property can only contain items of string, "%s" given', is_object($chargesTpbAccountNoItem) ? get_class($chargesTpbAccountNoItem) : gettype($chargesTpbAccountNoItem)), __LINE__);
            }
        }
        if (is_null($tpbAccountNo) || (is_array($tpbAccountNo) && empty($tpbAccountNo))) {
            unset($this->tpbAccountNo);
        } else {
            $this->tpbAccountNo = $tpbAccountNo;
        }
        return $this;
    }
    /**
     * Add item to tpbAccountNo value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GreenwayDirectService\StructType\Charges
     */
    public function addToTpbAccountNo($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The tpbAccountNo property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tpbAccountNo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GreenwayDirectService\StructType\Charges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
