<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for objectHeader StructType
 * @subpackage Structs
 */
class ObjectHeader extends AbstractStructBase
{
    /**
     * The TemplateID
     * @var int
     */
    public $TemplateID;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\PackageData
     */
    public $Data;
    /**
     * Constructor method for objectHeader
     * @uses ObjectHeader::setTemplateID()
     * @uses ObjectHeader::setData()
     * @param int $templateID
     * @param \soglasie\StructType\PackageData $data
     */
    public function __construct($templateID = null, \soglasie\StructType\PackageData $data = null)
    {
        $this
            ->setTemplateID($templateID)
            ->setData($data);
    }
    /**
     * Get TemplateID value
     * @return int|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \soglasie\StructType\ObjectHeader
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !is_numeric($templateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get Data value
     * @return \soglasie\StructType\PackageData|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \soglasie\StructType\PackageData $data
     * @return \soglasie\StructType\ObjectHeader
     */
    public function setData(\soglasie\StructType\PackageData $data = null)
    {
        $this->Data = $data;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\ObjectHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
