<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loaderList StructType
 * @subpackage Structs
 */
class LoaderList extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderItem[]
     */
    public $Item;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\Items
     */
    public $Items;
    /**
     * The Object
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderObject[]
     */
    public $Object;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderError[]
     */
    public $Error;
    /**
     * Constructor method for loaderList
     * @uses LoaderList::setDescription()
     * @uses LoaderList::setItem()
     * @uses LoaderList::setItems()
     * @uses LoaderList::setObject()
     * @uses LoaderList::setError()
     * @param string $description
     * @param \soglasie\StructType\LoaderItem[] $item
     * @param \soglasie\StructType\Items $items
     * @param \soglasie\StructType\LoaderObject[] $object
     * @param \soglasie\StructType\LoaderError[] $error
     */
    public function __construct($description = null, array $item = array(), \soglasie\StructType\Items $items = null, array $object = array(), array $error = array())
    {
        $this
            ->setDescription($description)
            ->setItem($item)
            ->setItems($items)
            ->setObject($object)
            ->setError($error);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \soglasie\StructType\LoaderList
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Item value
     * @return \soglasie\StructType\LoaderItem[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem[] $item
     * @return \soglasie\StructType\LoaderList
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $loaderListItemItem) {
            // validation for constraint: itemType
            if (!$loaderListItemItem instanceof \soglasie\StructType\LoaderItem) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($loaderListItemItem) ? get_class($loaderListItemItem) : gettype($loaderListItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem $item
     * @return \soglasie\StructType\LoaderList
     */
    public function addToItem(\soglasie\StructType\LoaderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderItem) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get Items value
     * @return \soglasie\StructType\Items|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \soglasie\StructType\Items $items
     * @return \soglasie\StructType\LoaderList
     */
    public function setItems(\soglasie\StructType\Items $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Object value
     * @return \soglasie\StructType\LoaderObject[]|null
     */
    public function getObject()
    {
        return $this->Object;
    }
    /**
     * Set Object value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderObject[] $object
     * @return \soglasie\StructType\LoaderList
     */
    public function setObject(array $object = array())
    {
        foreach ($object as $loaderListObjectItem) {
            // validation for constraint: itemType
            if (!$loaderListObjectItem instanceof \soglasie\StructType\LoaderObject) {
                throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \soglasie\StructType\LoaderObject, "%s" given', is_object($loaderListObjectItem) ? get_class($loaderListObjectItem) : gettype($loaderListObjectItem)), __LINE__);
            }
        }
        $this->Object = $object;
        return $this;
    }
    /**
     * Add item to Object value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderObject $item
     * @return \soglasie\StructType\LoaderList
     */
    public function addToObject(\soglasie\StructType\LoaderObject $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderObject) {
            throw new \InvalidArgumentException(sprintf('The Object property can only contain items of \soglasie\StructType\LoaderObject, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Object[] = $item;
        return $this;
    }
    /**
     * Get Error value
     * @return \soglasie\StructType\LoaderError[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderError[] $error
     * @return \soglasie\StructType\LoaderList
     */
    public function setError(array $error = array())
    {
        foreach ($error as $loaderListErrorItem) {
            // validation for constraint: itemType
            if (!$loaderListErrorItem instanceof \soglasie\StructType\LoaderError) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \soglasie\StructType\LoaderError, "%s" given', is_object($loaderListErrorItem) ? get_class($loaderListErrorItem) : gettype($loaderListErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderError $item
     * @return \soglasie\StructType\LoaderList
     */
    public function addToError(\soglasie\StructType\LoaderError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderError) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \soglasie\StructType\LoaderError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\LoaderList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
