<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loaderItem StructType
 * @subpackage Structs
 */
class LoaderItem extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $State;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * Constructor method for loaderItem
     * @uses LoaderItem::setDescription()
     * @uses LoaderItem::setValue()
     * @uses LoaderItem::setState()
     * @uses LoaderItem::setCode()
     * @param string $description
     * @param string $value
     * @param int $state
     * @param int $code
     */
    public function __construct($description = null, $value = null, $state = null, $code = null)
    {
        $this
            ->setDescription($description)
            ->setValue($value)
            ->setState($state)
            ->setCode($code);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \soglasie\StructType\LoaderItem
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \soglasie\StructType\LoaderItem
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get State value
     * @return int|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param int $state
     * @return \soglasie\StructType\LoaderItem
     */
    public function setState($state = null)
    {
        // validation for constraint: int
        if (!is_null($state) && !is_numeric($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \soglasie\StructType\LoaderItem
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\LoaderItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
