<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCatalogInfo StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCatalogInfo
 * @subpackage Structs
 */
class GetCatalogInfo extends AbstractStructBase
{
    /**
     * The test
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $test;
    /**
     * The TemplateID
     * @var int
     */
    public $TemplateID;
    /**
     * The CatalogID
     * @var int
     */
    public $CatalogID;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Product;
    /**
     * Constructor method for GetCatalogInfo
     * @uses GetCatalogInfo::setTest()
     * @uses GetCatalogInfo::setTemplateID()
     * @uses GetCatalogInfo::setCatalogID()
     * @uses GetCatalogInfo::setProduct()
     * @param bool $test
     * @param int $templateID
     * @param int $catalogID
     * @param string $product
     */
    public function __construct($test = null, $templateID = null, $catalogID = null, $product = null)
    {
        $this
            ->setTest($test)
            ->setTemplateID($templateID)
            ->setCatalogID($catalogID)
            ->setProduct($product);
    }
    /**
     * Get test value
     * @return bool|null
     */
    public function getTest()
    {
        return $this->test;
    }
    /**
     * Set test value
     * @param bool $test
     * @return \soglasie\StructType\GetCatalogInfo
     */
    public function setTest($test = null)
    {
        $this->test = $test;
        return $this;
    }
    /**
     * Get TemplateID value
     * @return int|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \soglasie\StructType\GetCatalogInfo
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !is_numeric($templateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get CatalogID value
     * @return int|null
     */
    public function getCatalogID()
    {
        return $this->CatalogID;
    }
    /**
     * Set CatalogID value
     * @param int $catalogID
     * @return \soglasie\StructType\GetCatalogInfo
     */
    public function setCatalogID($catalogID = null)
    {
        // validation for constraint: int
        if (!is_null($catalogID) && !is_numeric($catalogID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($catalogID)), __LINE__);
        }
        $this->CatalogID = $catalogID;
        return $this;
    }
    /**
     * Get Product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param string $product
     * @return \soglasie\StructType\GetCatalogInfo
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\GetCatalogInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
