<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for documentList StructType
 * @subpackage Structs
 */
class DocumentList extends AbstractStructBase
{
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\ErrorDetail
     */
    public $Error;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\Document[]
     */
    public $Document;
    /**
     * Constructor method for documentList
     * @uses DocumentList::setError()
     * @uses DocumentList::setDocument()
     * @param \soglasie\StructType\ErrorDetail $error
     * @param \soglasie\StructType\Document[] $document
     */
    public function __construct(\soglasie\StructType\ErrorDetail $error = null, array $document = array())
    {
        $this
            ->setError($error)
            ->setDocument($document);
    }
    /**
     * Get Error value
     * @return \soglasie\StructType\ErrorDetail|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \soglasie\StructType\ErrorDetail $error
     * @return \soglasie\StructType\DocumentList
     */
    public function setError(\soglasie\StructType\ErrorDetail $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Document value
     * @return \soglasie\StructType\Document[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\Document[] $document
     * @return \soglasie\StructType\DocumentList
     */
    public function setDocument(array $document = array())
    {
        foreach ($document as $documentListDocumentItem) {
            // validation for constraint: itemType
            if (!$documentListDocumentItem instanceof \soglasie\StructType\Document) {
                throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \soglasie\StructType\Document, "%s" given', is_object($documentListDocumentItem) ? get_class($documentListDocumentItem) : gettype($documentListDocumentItem)), __LINE__);
            }
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\Document $item
     * @return \soglasie\StructType\DocumentList
     */
    public function addToDocument(\soglasie\StructType\Document $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\Document) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of \soglasie\StructType\Document, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\DocumentList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
