<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for List StructType
 * @subpackage Structs
 */
class _List extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \soglasie\StructType\CatalogItem[]
     */
    public $Item;
    /**
     * Constructor method for List
     * @uses _List::setItem()
     * @param \soglasie\StructType\CatalogItem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \soglasie\StructType\CatalogItem[]|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\CatalogItem[] $item
     * @return \soglasie\StructType\_List
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $listItemItem) {
            // validation for constraint: itemType
            if (!$listItemItem instanceof \soglasie\StructType\CatalogItem) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\CatalogItem, "%s" given', is_object($listItemItem) ? get_class($listItemItem) : gettype($listItemItem)), __LINE__);
            }
        }
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\CatalogItem $item
     * @return \soglasie\StructType\_List
     */
    public function addToItem(\soglasie\StructType\CatalogItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\CatalogItem) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\CatalogItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\_List
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
