<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for statusPackage StructType
 * @subpackage Structs
 */
class StatusPackage extends AbstractStructBase
{
    /**
     * The TemplateID
     * @var int
     */
    public $TemplateID;
    /**
     * The PackageNumber
     * @var string
     */
    public $PackageNumber;
    /**
     * The PackageDate
     * @var string
     */
    public $PackageDate;
    /**
     * Constructor method for statusPackage
     * @uses StatusPackage::setTemplateID()
     * @uses StatusPackage::setPackageNumber()
     * @uses StatusPackage::setPackageDate()
     * @param int $templateID
     * @param string $packageNumber
     * @param string $packageDate
     */
    public function __construct($templateID = null, $packageNumber = null, $packageDate = null)
    {
        $this
            ->setTemplateID($templateID)
            ->setPackageNumber($packageNumber)
            ->setPackageDate($packageDate);
    }
    /**
     * Get TemplateID value
     * @return int|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \soglasie\StructType\StatusPackage
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !is_numeric($templateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Get PackageNumber value
     * @return string|null
     */
    public function getPackageNumber()
    {
        return $this->PackageNumber;
    }
    /**
     * Set PackageNumber value
     * @param string $packageNumber
     * @return \soglasie\StructType\StatusPackage
     */
    public function setPackageNumber($packageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packageNumber) && !is_string($packageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageNumber)), __LINE__);
        }
        $this->PackageNumber = $packageNumber;
        return $this;
    }
    /**
     * Get PackageDate value
     * @return string|null
     */
    public function getPackageDate()
    {
        return $this->PackageDate;
    }
    /**
     * Set PackageDate value
     * @param string $packageDate
     * @return \soglasie\StructType\StatusPackage
     */
    public function setPackageDate($packageDate = null)
    {
        // validation for constraint: string
        if (!is_null($packageDate) && !is_string($packageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageDate)), __LINE__);
        }
        $this->PackageDate = $packageDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\StatusPackage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
