<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sellerInfo StructType
 * @subpackage Structs
 */
class SellerInfo extends AbstractStructBase
{
    /**
     * The IKP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IKP;
    /**
     * The BENEFICIARYID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BENEFICIARYID;
    /**
     * The SPECNOTICE
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SPECNOTICE;
    /**
     * The PFOWNEREQINSURER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PFOWNEREQINSURER;
    /**
     * The PFOWNERNEQINSURER
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PFOWNERNEQINSURER;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\ErrorDetail
     */
    public $Error;
    /**
     * Constructor method for sellerInfo
     * @uses SellerInfo::setIKP()
     * @uses SellerInfo::setBENEFICIARYID()
     * @uses SellerInfo::setSPECNOTICE()
     * @uses SellerInfo::setPFOWNEREQINSURER()
     * @uses SellerInfo::setPFOWNERNEQINSURER()
     * @uses SellerInfo::setError()
     * @param string $iKP
     * @param string $bENEFICIARYID
     * @param string $sPECNOTICE
     * @param string $pFOWNEREQINSURER
     * @param string $pFOWNERNEQINSURER
     * @param \soglasie\StructType\ErrorDetail $error
     */
    public function __construct($iKP = null, $bENEFICIARYID = null, $sPECNOTICE = null, $pFOWNEREQINSURER = null, $pFOWNERNEQINSURER = null, \soglasie\StructType\ErrorDetail $error = null)
    {
        $this
            ->setIKP($iKP)
            ->setBENEFICIARYID($bENEFICIARYID)
            ->setSPECNOTICE($sPECNOTICE)
            ->setPFOWNEREQINSURER($pFOWNEREQINSURER)
            ->setPFOWNERNEQINSURER($pFOWNERNEQINSURER)
            ->setError($error);
    }
    /**
     * Get IKP value
     * @return string|null
     */
    public function getIKP()
    {
        return $this->IKP;
    }
    /**
     * Set IKP value
     * @param string $iKP
     * @return \soglasie\StructType\SellerInfo
     */
    public function setIKP($iKP = null)
    {
        // validation for constraint: string
        if (!is_null($iKP) && !is_string($iKP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iKP)), __LINE__);
        }
        $this->IKP = $iKP;
        return $this;
    }
    /**
     * Get BENEFICIARYID value
     * @return string|null
     */
    public function getBENEFICIARYID()
    {
        return $this->BENEFICIARYID;
    }
    /**
     * Set BENEFICIARYID value
     * @param string $bENEFICIARYID
     * @return \soglasie\StructType\SellerInfo
     */
    public function setBENEFICIARYID($bENEFICIARYID = null)
    {
        // validation for constraint: string
        if (!is_null($bENEFICIARYID) && !is_string($bENEFICIARYID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bENEFICIARYID)), __LINE__);
        }
        $this->BENEFICIARYID = $bENEFICIARYID;
        return $this;
    }
    /**
     * Get SPECNOTICE value
     * @return string|null
     */
    public function getSPECNOTICE()
    {
        return $this->SPECNOTICE;
    }
    /**
     * Set SPECNOTICE value
     * @param string $sPECNOTICE
     * @return \soglasie\StructType\SellerInfo
     */
    public function setSPECNOTICE($sPECNOTICE = null)
    {
        // validation for constraint: string
        if (!is_null($sPECNOTICE) && !is_string($sPECNOTICE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPECNOTICE)), __LINE__);
        }
        $this->SPECNOTICE = $sPECNOTICE;
        return $this;
    }
    /**
     * Get PFOWNEREQINSURER value
     * @return string|null
     */
    public function getPFOWNEREQINSURER()
    {
        return $this->PFOWNEREQINSURER;
    }
    /**
     * Set PFOWNEREQINSURER value
     * @param string $pFOWNEREQINSURER
     * @return \soglasie\StructType\SellerInfo
     */
    public function setPFOWNEREQINSURER($pFOWNEREQINSURER = null)
    {
        // validation for constraint: string
        if (!is_null($pFOWNEREQINSURER) && !is_string($pFOWNEREQINSURER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pFOWNEREQINSURER)), __LINE__);
        }
        $this->PFOWNEREQINSURER = $pFOWNEREQINSURER;
        return $this;
    }
    /**
     * Get PFOWNERNEQINSURER value
     * @return string|null
     */
    public function getPFOWNERNEQINSURER()
    {
        return $this->PFOWNERNEQINSURER;
    }
    /**
     * Set PFOWNERNEQINSURER value
     * @param string $pFOWNERNEQINSURER
     * @return \soglasie\StructType\SellerInfo
     */
    public function setPFOWNERNEQINSURER($pFOWNERNEQINSURER = null)
    {
        // validation for constraint: string
        if (!is_null($pFOWNERNEQINSURER) && !is_string($pFOWNERNEQINSURER)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pFOWNERNEQINSURER)), __LINE__);
        }
        $this->PFOWNERNEQINSURER = $pFOWNERNEQINSURER;
        return $this;
    }
    /**
     * Get Error value
     * @return \soglasie\StructType\ErrorDetail|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param \soglasie\StructType\ErrorDetail $error
     * @return \soglasie\StructType\SellerInfo
     */
    public function setError(\soglasie\StructType\ErrorDetail $error = null)
    {
        $this->Error = $error;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\SellerInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
