<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for packageHeader StructType
 * @subpackage Structs
 */
class PackageHeader extends ObjectHeader
{
    /**
     * The PackageNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageNumber;
    /**
     * The PackageDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PackageDate;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UserID;
    /**
     * Constructor method for packageHeader
     * @uses PackageHeader::setPackageNumber()
     * @uses PackageHeader::setPackageDate()
     * @uses PackageHeader::setUserID()
     * @param string $packageNumber
     * @param string $packageDate
     * @param int $userID
     */
    public function __construct($packageNumber = null, $packageDate = null, $userID = null)
    {
        $this
            ->setPackageNumber($packageNumber)
            ->setPackageDate($packageDate)
            ->setUserID($userID);
    }
    /**
     * Get PackageNumber value
     * @return string|null
     */
    public function getPackageNumber()
    {
        return $this->PackageNumber;
    }
    /**
     * Set PackageNumber value
     * @param string $packageNumber
     * @return \soglasie\StructType\PackageHeader
     */
    public function setPackageNumber($packageNumber = null)
    {
        // validation for constraint: string
        if (!is_null($packageNumber) && !is_string($packageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageNumber)), __LINE__);
        }
        $this->PackageNumber = $packageNumber;
        return $this;
    }
    /**
     * Get PackageDate value
     * @return string|null
     */
    public function getPackageDate()
    {
        return $this->PackageDate;
    }
    /**
     * Set PackageDate value
     * @param string $packageDate
     * @return \soglasie\StructType\PackageHeader
     */
    public function setPackageDate($packageDate = null)
    {
        // validation for constraint: string
        if (!is_null($packageDate) && !is_string($packageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($packageDate)), __LINE__);
        }
        $this->PackageDate = $packageDate;
        return $this;
    }
    /**
     * Get UserID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \soglasie\StructType\PackageHeader
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\PackageHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
