<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loaderResponse StructType
 * @subpackage Structs
 */
class LoaderResponse extends AbstractStructBase
{
    /**
     * The PackageID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PackageID;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderItem[]
     */
    public $Item;
    /**
     * The List
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderList[]
     */
    public $List;
    /**
     * The Error
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderError[]
     */
    public $Error;
    /**
     * The userid
     * @var int
     */
    public $userid;
    /**
     * The time
     * @var int
     */
    public $time;
    /**
     * The proxy_time
     * @var int
     */
    public $proxy_time;
    /**
     * Constructor method for loaderResponse
     * @uses LoaderResponse::setPackageID()
     * @uses LoaderResponse::setItem()
     * @uses LoaderResponse::setList()
     * @uses LoaderResponse::setError()
     * @uses LoaderResponse::setUserid()
     * @uses LoaderResponse::setTime()
     * @uses LoaderResponse::setProxy_time()
     * @param int $packageID
     * @param \soglasie\StructType\LoaderItem[] $item
     * @param \soglasie\StructType\LoaderList[] $list
     * @param \soglasie\StructType\LoaderError[] $error
     * @param int $userid
     * @param int $time
     * @param int $proxy_time
     */
    public function __construct($packageID = null, array $item = array(), array $list = array(), array $error = array(), $userid = null, $time = null, $proxy_time = null)
    {
        $this
            ->setPackageID($packageID)
            ->setItem($item)
            ->setList($list)
            ->setError($error)
            ->setUserid($userid)
            ->setTime($time)
            ->setProxy_time($proxy_time);
    }
    /**
     * Get PackageID value
     * @return int|null
     */
    public function getPackageID()
    {
        return $this->PackageID;
    }
    /**
     * Set PackageID value
     * @param int $packageID
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setPackageID($packageID = null)
    {
        // validation for constraint: int
        if (!is_null($packageID) && !is_numeric($packageID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($packageID)), __LINE__);
        }
        $this->PackageID = $packageID;
        return $this;
    }
    /**
     * Get Item value
     * @return \soglasie\StructType\LoaderItem[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem[] $item
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $loaderResponseItemItem) {
            // validation for constraint: itemType
            if (!$loaderResponseItemItem instanceof \soglasie\StructType\LoaderItem) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($loaderResponseItemItem) ? get_class($loaderResponseItemItem) : gettype($loaderResponseItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem $item
     * @return \soglasie\StructType\LoaderResponse
     */
    public function addToItem(\soglasie\StructType\LoaderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderItem) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get List value
     * @return \soglasie\StructType\LoaderList[]|null
     */
    public function getList()
    {
        return $this->List;
    }
    /**
     * Set List value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderList[] $list
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setList(array $list = array())
    {
        foreach ($list as $loaderResponseListItem) {
            // validation for constraint: itemType
            if (!$loaderResponseListItem instanceof \soglasie\StructType\LoaderList) {
                throw new \InvalidArgumentException(sprintf('The List property can only contain items of \soglasie\StructType\LoaderList, "%s" given', is_object($loaderResponseListItem) ? get_class($loaderResponseListItem) : gettype($loaderResponseListItem)), __LINE__);
            }
        }
        $this->List = $list;
        return $this;
    }
    /**
     * Add item to List value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderList $item
     * @return \soglasie\StructType\LoaderResponse
     */
    public function addToList(\soglasie\StructType\LoaderList $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderList) {
            throw new \InvalidArgumentException(sprintf('The List property can only contain items of \soglasie\StructType\LoaderList, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->List[] = $item;
        return $this;
    }
    /**
     * Get Error value
     * @return \soglasie\StructType\LoaderError[]|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderError[] $error
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setError(array $error = array())
    {
        foreach ($error as $loaderResponseErrorItem) {
            // validation for constraint: itemType
            if (!$loaderResponseErrorItem instanceof \soglasie\StructType\LoaderError) {
                throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \soglasie\StructType\LoaderError, "%s" given', is_object($loaderResponseErrorItem) ? get_class($loaderResponseErrorItem) : gettype($loaderResponseErrorItem)), __LINE__);
            }
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Add item to Error value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderError $item
     * @return \soglasie\StructType\LoaderResponse
     */
    public function addToError(\soglasie\StructType\LoaderError $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderError) {
            throw new \InvalidArgumentException(sprintf('The Error property can only contain items of \soglasie\StructType\LoaderError, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Error[] = $item;
        return $this;
    }
    /**
     * Get userid value
     * @return int|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param int $userid
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: int
        if (!is_null($userid) && !is_numeric($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get time value
     * @return int|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param int $time
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setTime($time = null)
    {
        // validation for constraint: int
        if (!is_null($time) && !is_numeric($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get proxy_time value
     * @return int|null
     */
    public function getProxy_time()
    {
        return $this->proxy_time;
    }
    /**
     * Set proxy_time value
     * @param int $proxy_time
     * @return \soglasie\StructType\LoaderResponse
     */
    public function setProxy_time($proxy_time = null)
    {
        // validation for constraint: int
        if (!is_null($proxy_time) && !is_numeric($proxy_time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($proxy_time)), __LINE__);
        }
        $this->proxy_time = $proxy_time;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\LoaderResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
