<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTemplateListResponse StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetTemplateListResponse
 * @subpackage Structs
 */
class GetTemplateListResponse extends AbstractStructBase
{
    /**
     * The template
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\TemplateData[]
     */
    public $template;
    /**
     * Constructor method for GetTemplateListResponse
     * @uses GetTemplateListResponse::setTemplate()
     * @param \soglasie\StructType\TemplateData[] $template
     */
    public function __construct(array $template = array())
    {
        $this
            ->setTemplate($template);
    }
    /**
     * Get template value
     * @return \soglasie\StructType\TemplateData[]|null
     */
    public function getTemplate()
    {
        return $this->template;
    }
    /**
     * Set template value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\TemplateData[] $template
     * @return \soglasie\StructType\GetTemplateListResponse
     */
    public function setTemplate(array $template = array())
    {
        foreach ($template as $getTemplateListResponseTemplateItem) {
            // validation for constraint: itemType
            if (!$getTemplateListResponseTemplateItem instanceof \soglasie\StructType\TemplateData) {
                throw new \InvalidArgumentException(sprintf('The template property can only contain items of \soglasie\StructType\TemplateData, "%s" given', is_object($getTemplateListResponseTemplateItem) ? get_class($getTemplateListResponseTemplateItem) : gettype($getTemplateListResponseTemplateItem)), __LINE__);
            }
        }
        $this->template = $template;
        return $this;
    }
    /**
     * Add item to template value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\TemplateData $item
     * @return \soglasie\StructType\GetTemplateListResponse
     */
    public function addToTemplate(\soglasie\StructType\TemplateData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\TemplateData) {
            throw new \InvalidArgumentException(sprintf('The template property can only contain items of \soglasie\StructType\TemplateData, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->template[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\GetTemplateListResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
