<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSchema StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetSchema
 * @subpackage Structs
 */
class GetSchema extends AbstractStructBase
{
    /**
     * The test
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $test;
    /**
     * The TemplateID
     * @var int
     */
    public $TemplateID;
    /**
     * Constructor method for GetSchema
     * @uses GetSchema::setTest()
     * @uses GetSchema::setTemplateID()
     * @param bool $test
     * @param int $templateID
     */
    public function __construct($test = null, $templateID = null)
    {
        $this
            ->setTest($test)
            ->setTemplateID($templateID);
    }
    /**
     * Get test value
     * @return bool|null
     */
    public function getTest()
    {
        return $this->test;
    }
    /**
     * Set test value
     * @param bool $test
     * @return \soglasie\StructType\GetSchema
     */
    public function setTest($test = null)
    {
        $this->test = $test;
        return $this;
    }
    /**
     * Get TemplateID value
     * @return int|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \soglasie\StructType\GetSchema
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !is_numeric($templateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\GetSchema
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
