<?php

namespace soglasie\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recall ServiceType
 * @subpackage Services
 */
class Recall extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RecallObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\RecallObject $parameters
     * @return \soglasie\StructType\RecallObjectResponse|bool
     */
    public function RecallObject(\soglasie\StructType\RecallObject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RecallObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \soglasie\StructType\RecallObjectResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
