<?php

namespace soglasie\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetTemplateList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetTemplateList $parameters
     * @return \soglasie\StructType\GetTemplateListResponse|bool
     */
    public function GetTemplateList(\soglasie\StructType\GetTemplateList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTemplateList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusPackage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetStatusPackage $parameters
     * @return \soglasie\StructType\GetStatusPackageResponse|bool
     */
    public function GetStatusPackage(\soglasie\StructType\GetStatusPackage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatusPackage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetStatusObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetStatusObject $parameters
     * @return \soglasie\StructType\GetStatusObjectResponse|bool
     */
    public function GetStatusObject(\soglasie\StructType\GetStatusObject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetStatusObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCatalogList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetCatalogList $parameters
     * @return \soglasie\StructType\GetCatalogListResponse|bool
     */
    public function GetCatalogList(\soglasie\StructType\GetCatalogList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCatalogList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCatalogInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetCatalogInfo $parameters
     * @return \soglasie\StructType\GetCatalogInfoResponse|bool
     */
    public function GetCatalogInfo(\soglasie\StructType\GetCatalogInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCatalogInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetDocumentList $parameters
     * @return \soglasie\StructType\GetDocumentListResponse|bool
     */
    public function GetDocumentList(\soglasie\StructType\GetDocumentList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDocumentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchema
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetSchema $parameters
     * @return \soglasie\StructType\GetSchemaResponse|bool
     */
    public function GetSchema(\soglasie\StructType\GetSchema $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSchema($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocument
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetDocument $parameters
     * @return \soglasie\StructType\GetDocumentResponse|bool
     */
    public function GetDocument(\soglasie\StructType\GetDocument $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCodeIKP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\GetCodeIKP $parameters
     * @return \soglasie\StructType\GetCodeIKPResponse|bool
     */
    public function GetCodeIKP(\soglasie\StructType\GetCodeIKP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCodeIKP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \soglasie\StructType\GetCatalogInfoResponse|\soglasie\StructType\GetCatalogListResponse|\soglasie\StructType\GetCodeIKPResponse|\soglasie\StructType\GetDocumentListResponse|\soglasie\StructType\GetDocumentResponse|\soglasie\StructType\GetSchemaResponse|\soglasie\StructType\GetStatusObjectResponse|\soglasie\StructType\GetStatusPackageResponse|\soglasie\StructType\GetTemplateListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
