<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loaderObject StructType
 * @subpackage Structs
 */
class LoaderObject extends AbstractStructBase
{
    /**
     * The EntityID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EntityID;
    /**
     * The ObjectID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ObjectID;
    /**
     * The Result
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\Result
     */
    public $Result;
    /**
     * Constructor method for loaderObject
     * @uses LoaderObject::setEntityID()
     * @uses LoaderObject::setObjectID()
     * @uses LoaderObject::setResult()
     * @param int $entityID
     * @param string $objectID
     * @param \soglasie\StructType\Result $result
     */
    public function __construct($entityID = null, $objectID = null, \soglasie\StructType\Result $result = null)
    {
        $this
            ->setEntityID($entityID)
            ->setObjectID($objectID)
            ->setResult($result);
    }
    /**
     * Get EntityID value
     * @return int|null
     */
    public function getEntityID()
    {
        return $this->EntityID;
    }
    /**
     * Set EntityID value
     * @param int $entityID
     * @return \soglasie\StructType\LoaderObject
     */
    public function setEntityID($entityID = null)
    {
        // validation for constraint: int
        if (!is_null($entityID) && !is_numeric($entityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($entityID)), __LINE__);
        }
        $this->EntityID = $entityID;
        return $this;
    }
    /**
     * Get ObjectID value
     * @return string|null
     */
    public function getObjectID()
    {
        return $this->ObjectID;
    }
    /**
     * Set ObjectID value
     * @param string $objectID
     * @return \soglasie\StructType\LoaderObject
     */
    public function setObjectID($objectID = null)
    {
        // validation for constraint: string
        if (!is_null($objectID) && !is_string($objectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectID)), __LINE__);
        }
        $this->ObjectID = $objectID;
        return $this;
    }
    /**
     * Get Result value
     * @return \soglasie\StructType\Result|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param \soglasie\StructType\Result $result
     * @return \soglasie\StructType\LoaderObject
     */
    public function setResult(\soglasie\StructType\Result $result = null)
    {
        $this->Result = $result;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\LoaderObject
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
