<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for loaderError StructType
 * @subpackage Structs
 */
class LoaderError extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Info
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Info;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Details
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \soglasie\StructType\Details
     */
    public $Details;
    /**
     * Constructor method for loaderError
     * @uses LoaderError::setDescription()
     * @uses LoaderError::setInfo()
     * @uses LoaderError::setCode()
     * @uses LoaderError::setDetails()
     * @param string $description
     * @param string $info
     * @param int $code
     * @param \soglasie\StructType\Details $details
     */
    public function __construct($description = null, $info = null, $code = null, \soglasie\StructType\Details $details = null)
    {
        $this
            ->setDescription($description)
            ->setInfo($info)
            ->setCode($code)
            ->setDetails($details);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \soglasie\StructType\LoaderError
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->Info;
    }
    /**
     * Set Info value
     * @param string $info
     * @return \soglasie\StructType\LoaderError
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($info)), __LINE__);
        }
        $this->Info = $info;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \soglasie\StructType\LoaderError
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !is_numeric($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Details value
     * @return \soglasie\StructType\Details|null
     */
    public function getDetails()
    {
        return $this->Details;
    }
    /**
     * Set Details value
     * @param \soglasie\StructType\Details $details
     * @return \soglasie\StructType\LoaderError
     */
    public function setDetails(\soglasie\StructType\Details $details = null)
    {
        $this->Details = $details;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\LoaderError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
