<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Items StructType
 * @subpackage Structs
 */
class Items extends AbstractStructBase
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \soglasie\StructType\LoaderItem[]
     */
    public $Item;
    /**
     * Constructor method for Items
     * @uses Items::setItem()
     * @param \soglasie\StructType\LoaderItem[] $item
     */
    public function __construct(array $item = array())
    {
        $this
            ->setItem($item);
    }
    /**
     * Get Item value
     * @return \soglasie\StructType\LoaderItem[]|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem[] $item
     * @return \soglasie\StructType\Items
     */
    public function setItem(array $item = array())
    {
        foreach ($item as $itemsItemItem) {
            // validation for constraint: itemType
            if (!$itemsItemItem instanceof \soglasie\StructType\LoaderItem) {
                throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($itemsItemItem) ? get_class($itemsItemItem) : gettype($itemsItemItem)), __LINE__);
            }
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \soglasie\StructType\LoaderItem $item
     * @return \soglasie\StructType\Items
     */
    public function addToItem(\soglasie\StructType\LoaderItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \soglasie\StructType\LoaderItem) {
            throw new \InvalidArgumentException(sprintf('The Item property can only contain items of \soglasie\StructType\LoaderItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\Items
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
