<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDocument StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetDocument
 * @subpackage Structs
 */
class GetDocument extends AbstractStructBase
{
    /**
     * The test
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $test;
    /**
     * The TemplateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TemplateId;
    /**
     * The FileId
     * @var int
     */
    public $FileId;
    /**
     * Constructor method for GetDocument
     * @uses GetDocument::setTest()
     * @uses GetDocument::setTemplateId()
     * @uses GetDocument::setFileId()
     * @param bool $test
     * @param int $templateId
     * @param int $fileId
     */
    public function __construct($test = null, $templateId = null, $fileId = null)
    {
        $this
            ->setTest($test)
            ->setTemplateId($templateId)
            ->setFileId($fileId);
    }
    /**
     * Get test value
     * @return bool|null
     */
    public function getTest()
    {
        return $this->test;
    }
    /**
     * Set test value
     * @param bool $test
     * @return \soglasie\StructType\GetDocument
     */
    public function setTest($test = null)
    {
        $this->test = $test;
        return $this;
    }
    /**
     * Get TemplateId value
     * @return int|null
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return \soglasie\StructType\GetDocument
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !is_numeric($templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get FileId value
     * @return int|null
     */
    public function getFileId()
    {
        return $this->FileId;
    }
    /**
     * Set FileId value
     * @param int $fileId
     * @return \soglasie\StructType\GetDocument
     */
    public function setFileId($fileId = null)
    {
        // validation for constraint: int
        if (!is_null($fileId) && !is_numeric($fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileId)), __LINE__);
        }
        $this->FileId = $fileId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\GetDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
