<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCodeIKP StructType
 * Meta informations extracted from the WSDL
 * - type: tns:GetCodeIKP
 * @subpackage Structs
 */
class GetCodeIKP extends AbstractStructBase
{
    /**
     * The test
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $test;
    /**
     * The CodeInsurant
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeInsurant;
    /**
     * The INN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $INN;
    /**
     * The BIC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BIC;
    /**
     * The Product
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Product;
    /**
     * Constructor method for GetCodeIKP
     * @uses GetCodeIKP::setTest()
     * @uses GetCodeIKP::setCodeInsurant()
     * @uses GetCodeIKP::setINN()
     * @uses GetCodeIKP::setBIC()
     * @uses GetCodeIKP::setProduct()
     * @param bool $test
     * @param string $codeInsurant
     * @param string $iNN
     * @param string $bIC
     * @param string $product
     */
    public function __construct($test = null, $codeInsurant = null, $iNN = null, $bIC = null, $product = null)
    {
        $this
            ->setTest($test)
            ->setCodeInsurant($codeInsurant)
            ->setINN($iNN)
            ->setBIC($bIC)
            ->setProduct($product);
    }
    /**
     * Get test value
     * @return bool|null
     */
    public function getTest()
    {
        return $this->test;
    }
    /**
     * Set test value
     * @param bool $test
     * @return \soglasie\StructType\GetCodeIKP
     */
    public function setTest($test = null)
    {
        $this->test = $test;
        return $this;
    }
    /**
     * Get CodeInsurant value
     * @return string|null
     */
    public function getCodeInsurant()
    {
        return $this->CodeInsurant;
    }
    /**
     * Set CodeInsurant value
     * @param string $codeInsurant
     * @return \soglasie\StructType\GetCodeIKP
     */
    public function setCodeInsurant($codeInsurant = null)
    {
        // validation for constraint: string
        if (!is_null($codeInsurant) && !is_string($codeInsurant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeInsurant)), __LINE__);
        }
        $this->CodeInsurant = $codeInsurant;
        return $this;
    }
    /**
     * Get INN value
     * @return string|null
     */
    public function getINN()
    {
        return $this->INN;
    }
    /**
     * Set INN value
     * @param string $iNN
     * @return \soglasie\StructType\GetCodeIKP
     */
    public function setINN($iNN = null)
    {
        // validation for constraint: string
        if (!is_null($iNN) && !is_string($iNN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iNN)), __LINE__);
        }
        $this->INN = $iNN;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \soglasie\StructType\GetCodeIKP
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get Product value
     * @return string|null
     */
    public function getProduct()
    {
        return $this->Product;
    }
    /**
     * Set Product value
     * @param string $product
     * @return \soglasie\StructType\GetCodeIKP
     */
    public function setProduct($product = null)
    {
        // validation for constraint: string
        if (!is_null($product) && !is_string($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($product)), __LINE__);
        }
        $this->Product = $product;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\GetCodeIKP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
