<?php

namespace soglasie\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for document StructType
 * @subpackage Structs
 */
class Document extends AbstractStructBase
{
    /**
     * The TemplateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TemplateId;
    /**
     * The FileId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $FileId;
    /**
     * The Desc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Desc;
    /**
     * Constructor method for document
     * @uses Document::setTemplateId()
     * @uses Document::setFileId()
     * @uses Document::setDesc()
     * @param int $templateId
     * @param int $fileId
     * @param string $desc
     */
    public function __construct($templateId = null, $fileId = null, $desc = null)
    {
        $this
            ->setTemplateId($templateId)
            ->setFileId($fileId)
            ->setDesc($desc);
    }
    /**
     * Get TemplateId value
     * @return int|null
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return \soglasie\StructType\Document
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !is_numeric($templateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get FileId value
     * @return int|null
     */
    public function getFileId()
    {
        return $this->FileId;
    }
    /**
     * Set FileId value
     * @param int $fileId
     * @return \soglasie\StructType\Document
     */
    public function setFileId($fileId = null)
    {
        // validation for constraint: int
        if (!is_null($fileId) && !is_numeric($fileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileId)), __LINE__);
        }
        $this->FileId = $fileId;
        return $this;
    }
    /**
     * Get Desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->Desc;
    }
    /**
     * Set Desc value
     * @param string $desc
     * @return \soglasie\StructType\Document
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->Desc = $desc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \soglasie\StructType\Document
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
