<?php

namespace soglasie\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Load ServiceType
 * @subpackage Services
 */
class Load extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named LoadObject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\LoadObject $parameters
     * @return \soglasie\StructType\LoadObjectResponse|bool
     */
    public function LoadObject(\soglasie\StructType\LoadObject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->LoadObject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named LoadPackage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \soglasie\StructType\LoadPackage $parameters
     * @return \soglasie\StructType\LoadPackageResponse|bool
     */
    public function LoadPackage(\soglasie\StructType\LoadPackage $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->LoadPackage($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \soglasie\StructType\LoadObjectResponse|\soglasie\StructType\LoadPackageResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
