<?php

namespace soglasie;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'base64Binary' => '\\soglasie\\StructType\\Base64Binary',
            'hexBinary' => '\\soglasie\\StructType\\HexBinary',
            'GetSchema' => '\\soglasie\\StructType\\GetSchema',
            'GetSchemaResponse' => '\\soglasie\\StructType\\GetSchemaResponse',
            'LoadObject' => '\\soglasie\\StructType\\LoadObject',
            'objectHeader' => '\\soglasie\\StructType\\ObjectHeader',
            'packageData' => '\\soglasie\\StructType\\PackageData',
            'LoadObjectResponse' => '\\soglasie\\StructType\\LoadObjectResponse',
            'loaderResponse' => '\\soglasie\\StructType\\LoaderResponse',
            'loaderItem' => '\\soglasie\\StructType\\LoaderItem',
            'loaderList' => '\\soglasie\\StructType\\LoaderList',
            'Items' => '\\soglasie\\StructType\\Items',
            'loaderObject' => '\\soglasie\\StructType\\LoaderObject',
            'Result' => '\\soglasie\\StructType\\Result',
            'loaderResponseParam' => '\\soglasie\\StructType\\LoaderResponseParam',
            'loaderError' => '\\soglasie\\StructType\\LoaderError',
            'Details' => '\\soglasie\\StructType\\Details',
            'errorDetail' => '\\soglasie\\StructType\\ErrorDetail',
            'RecallObject' => '\\soglasie\\StructType\\RecallObject',
            'statusObject' => '\\soglasie\\StructType\\StatusObject',
            'RecallObjectResponse' => '\\soglasie\\StructType\\RecallObjectResponse',
            'GetCatalogInfo' => '\\soglasie\\StructType\\GetCatalogInfo',
            'GetCatalogInfoResponse' => '\\soglasie\\StructType\\GetCatalogInfoResponse',
            'catalogList' => '\\soglasie\\StructType\\CatalogList',
            'List' => '\\soglasie\\StructType\\_List',
            'catalogError' => '\\soglasie\\StructType\\CatalogError',
            'catalogItem' => '\\soglasie\\StructType\\CatalogItem',
            'GetCatalogList' => '\\soglasie\\StructType\\GetCatalogList',
            'GetCatalogListResponse' => '\\soglasie\\StructType\\GetCatalogListResponse',
            'GetTemplateList' => '\\soglasie\\StructType\\GetTemplateList',
            'GetTemplateListResponse' => '\\soglasie\\StructType\\GetTemplateListResponse',
            'templateData' => '\\soglasie\\StructType\\TemplateData',
            'Exception' => '\\soglasie\\StructType\\Exception',
            'GetCodeIKP' => '\\soglasie\\StructType\\GetCodeIKP',
            'GetCodeIKPResponse' => '\\soglasie\\StructType\\GetCodeIKPResponse',
            'sellerInfo' => '\\soglasie\\StructType\\SellerInfo',
            'GetDocument' => '\\soglasie\\StructType\\GetDocument',
            'GetDocumentResponse' => '\\soglasie\\StructType\\GetDocumentResponse',
            'documentData' => '\\soglasie\\StructType\\DocumentData',
            'GetStatusObject' => '\\soglasie\\StructType\\GetStatusObject',
            'GetStatusObjectResponse' => '\\soglasie\\StructType\\GetStatusObjectResponse',
            'GetStatusPackage' => '\\soglasie\\StructType\\GetStatusPackage',
            'statusPackage' => '\\soglasie\\StructType\\StatusPackage',
            'GetStatusPackageResponse' => '\\soglasie\\StructType\\GetStatusPackageResponse',
            'LoadPackage' => '\\soglasie\\StructType\\LoadPackage',
            'packageHeader' => '\\soglasie\\StructType\\PackageHeader',
            'LoadPackageResponse' => '\\soglasie\\StructType\\LoadPackageResponse',
            'GetDocumentList' => '\\soglasie\\StructType\\GetDocumentList',
            'GetDocumentListResponse' => '\\soglasie\\StructType\\GetDocumentListResponse',
            'documentList' => '\\soglasie\\StructType\\DocumentList',
            'document' => '\\soglasie\\StructType\\Document',
        );
    }
}
