<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for updateSuspect StructType
 * @subpackage Structs
 */
class UpdateSuspect extends AbstractStructBase
{
    /**
     * The login
     * @var string
     */
    public $login;
    /**
     * The password
     * @var string
     */
    public $password;
    /**
     * The suspectId
     * @var int
     */
    public $suspectId;
    /**
     * The addSuspectStructure
     * @var \StructType\AddSuspectStructure
     */
    public $addSuspectStructure;
    /**
     * Constructor method for updateSuspect
     * @uses UpdateSuspect::setLogin()
     * @uses UpdateSuspect::setPassword()
     * @uses UpdateSuspect::setSuspectId()
     * @uses UpdateSuspect::setAddSuspectStructure()
     * @param string $login
     * @param string $password
     * @param int $suspectId
     * @param \StructType\AddSuspectStructure $addSuspectStructure
     */
    public function __construct($login = null, $password = null, $suspectId = null, \StructType\AddSuspectStructure $addSuspectStructure = null)
    {
        $this
            ->setLogin($login)
            ->setPassword($password)
            ->setSuspectId($suspectId)
            ->setAddSuspectStructure($addSuspectStructure);
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\UpdateSuspect
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\UpdateSuspect
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get suspectId value
     * @return int|null
     */
    public function getSuspectId()
    {
        return $this->suspectId;
    }
    /**
     * Set suspectId value
     * @param int $suspectId
     * @return \StructType\UpdateSuspect
     */
    public function setSuspectId($suspectId = null)
    {
        // validation for constraint: int
        if (!is_null($suspectId) && !is_numeric($suspectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suspectId)), __LINE__);
        }
        $this->suspectId = $suspectId;
        return $this;
    }
    /**
     * Get addSuspectStructure value
     * @return \StructType\AddSuspectStructure|null
     */
    public function getAddSuspectStructure()
    {
        return $this->addSuspectStructure;
    }
    /**
     * Set addSuspectStructure value
     * @param \StructType\AddSuspectStructure $addSuspectStructure
     * @return \StructType\UpdateSuspect
     */
    public function setAddSuspectStructure(\StructType\AddSuspectStructure $addSuspectStructure = null)
    {
        $this->addSuspectStructure = $addSuspectStructure;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateSuspect
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
