<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferWS StructType
 * @subpackage Structs
 */
class OfferWS extends AbstractStructBase
{
    /**
     * The Technology
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Technology;
    /**
     * The Media
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Media;
    /**
     * The ConnectedSFR
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $ConnectedSFR;
    /**
     * The NRC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NRC;
    /**
     * The MRC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MRC;
    /**
     * The TTD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TTD;
    /**
     * The ValidateOffer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValidateOffer;
    /**
     * The DurationContract
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DurationContract;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The bandwidth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bandwidth;
    /**
     * The TypeOfAccess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfAccess;
    /**
     * The TypeOfZone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfZone;
    /**
     * The CE2OSRHD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CE2OSRHD;
    /**
     * The CELANSRTHD
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CELANSRTHD;
    /**
     * The NRCComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NRCComment;
    /**
     * The MRCComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MRCComment;
    /**
     * The Engagement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Engagement;
    /**
     * The TTDComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TTDComment;
    /**
     * The ValidateOfferComment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValidateOfferComment;
    /**
     * The RefQuote
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RefQuote;
    /**
     * Constructor method for OfferWS
     * @uses OfferWS::setTechnology()
     * @uses OfferWS::setMedia()
     * @uses OfferWS::setConnectedSFR()
     * @uses OfferWS::setNRC()
     * @uses OfferWS::setMRC()
     * @uses OfferWS::setTTD()
     * @uses OfferWS::setValidateOffer()
     * @uses OfferWS::setDurationContract()
     * @uses OfferWS::setProductName()
     * @uses OfferWS::setBandwidth()
     * @uses OfferWS::setTypeOfAccess()
     * @uses OfferWS::setTypeOfZone()
     * @uses OfferWS::setCE2OSRHD()
     * @uses OfferWS::setCELANSRTHD()
     * @uses OfferWS::setNRCComment()
     * @uses OfferWS::setMRCComment()
     * @uses OfferWS::setEngagement()
     * @uses OfferWS::setTTDComment()
     * @uses OfferWS::setValidateOfferComment()
     * @uses OfferWS::setRefQuote()
     * @param int $technology
     * @param int $media
     * @param bool $connectedSFR
     * @param int $nRC
     * @param int $mRC
     * @param int $tTD
     * @param string $validateOffer
     * @param int $durationContract
     * @param string $productName
     * @param string $bandwidth
     * @param string $typeOfAccess
     * @param string $typeOfZone
     * @param string $cE2OSRHD
     * @param string $cELANSRTHD
     * @param string $nRCComment
     * @param string $mRCComment
     * @param string $engagement
     * @param string $tTDComment
     * @param string $validateOfferComment
     * @param string $refQuote
     */
    public function __construct($technology = null, $media = null, $connectedSFR = null, $nRC = null, $mRC = null, $tTD = null, $validateOffer = null, $durationContract = null, $productName = null, $bandwidth = null, $typeOfAccess = null, $typeOfZone = null, $cE2OSRHD = null, $cELANSRTHD = null, $nRCComment = null, $mRCComment = null, $engagement = null, $tTDComment = null, $validateOfferComment = null, $refQuote = null)
    {
        $this
            ->setTechnology($technology)
            ->setMedia($media)
            ->setConnectedSFR($connectedSFR)
            ->setNRC($nRC)
            ->setMRC($mRC)
            ->setTTD($tTD)
            ->setValidateOffer($validateOffer)
            ->setDurationContract($durationContract)
            ->setProductName($productName)
            ->setBandwidth($bandwidth)
            ->setTypeOfAccess($typeOfAccess)
            ->setTypeOfZone($typeOfZone)
            ->setCE2OSRHD($cE2OSRHD)
            ->setCELANSRTHD($cELANSRTHD)
            ->setNRCComment($nRCComment)
            ->setMRCComment($mRCComment)
            ->setEngagement($engagement)
            ->setTTDComment($tTDComment)
            ->setValidateOfferComment($validateOfferComment)
            ->setRefQuote($refQuote);
    }
    /**
     * Get Technology value
     * @return int
     */
    public function getTechnology()
    {
        return $this->Technology;
    }
    /**
     * Set Technology value
     * @param int $technology
     * @return \StructType\OfferWS
     */
    public function setTechnology($technology = null)
    {
        // validation for constraint: int
        if (!is_null($technology) && !is_numeric($technology)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($technology)), __LINE__);
        }
        $this->Technology = $technology;
        return $this;
    }
    /**
     * Get Media value
     * @return int
     */
    public function getMedia()
    {
        return $this->Media;
    }
    /**
     * Set Media value
     * @param int $media
     * @return \StructType\OfferWS
     */
    public function setMedia($media = null)
    {
        // validation for constraint: int
        if (!is_null($media) && !is_numeric($media)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($media)), __LINE__);
        }
        $this->Media = $media;
        return $this;
    }
    /**
     * Get ConnectedSFR value
     * @return bool
     */
    public function getConnectedSFR()
    {
        return $this->ConnectedSFR;
    }
    /**
     * Set ConnectedSFR value
     * @param bool $connectedSFR
     * @return \StructType\OfferWS
     */
    public function setConnectedSFR($connectedSFR = null)
    {
        // validation for constraint: boolean
        if (!is_null($connectedSFR) && !is_bool($connectedSFR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($connectedSFR)), __LINE__);
        }
        $this->ConnectedSFR = $connectedSFR;
        return $this;
    }
    /**
     * Get NRC value
     * @return int
     */
    public function getNRC()
    {
        return $this->NRC;
    }
    /**
     * Set NRC value
     * @param int $nRC
     * @return \StructType\OfferWS
     */
    public function setNRC($nRC = null)
    {
        // validation for constraint: int
        if (!is_null($nRC) && !is_numeric($nRC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nRC)), __LINE__);
        }
        $this->NRC = $nRC;
        return $this;
    }
    /**
     * Get MRC value
     * @return int
     */
    public function getMRC()
    {
        return $this->MRC;
    }
    /**
     * Set MRC value
     * @param int $mRC
     * @return \StructType\OfferWS
     */
    public function setMRC($mRC = null)
    {
        // validation for constraint: int
        if (!is_null($mRC) && !is_numeric($mRC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($mRC)), __LINE__);
        }
        $this->MRC = $mRC;
        return $this;
    }
    /**
     * Get TTD value
     * @return int
     */
    public function getTTD()
    {
        return $this->TTD;
    }
    /**
     * Set TTD value
     * @param int $tTD
     * @return \StructType\OfferWS
     */
    public function setTTD($tTD = null)
    {
        // validation for constraint: int
        if (!is_null($tTD) && !is_numeric($tTD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tTD)), __LINE__);
        }
        $this->TTD = $tTD;
        return $this;
    }
    /**
     * Get ValidateOffer value
     * @return string
     */
    public function getValidateOffer()
    {
        return $this->ValidateOffer;
    }
    /**
     * Set ValidateOffer value
     * @param string $validateOffer
     * @return \StructType\OfferWS
     */
    public function setValidateOffer($validateOffer = null)
    {
        // validation for constraint: string
        if (!is_null($validateOffer) && !is_string($validateOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validateOffer)), __LINE__);
        }
        $this->ValidateOffer = $validateOffer;
        return $this;
    }
    /**
     * Get DurationContract value
     * @return int
     */
    public function getDurationContract()
    {
        return $this->DurationContract;
    }
    /**
     * Set DurationContract value
     * @param int $durationContract
     * @return \StructType\OfferWS
     */
    public function setDurationContract($durationContract = null)
    {
        // validation for constraint: int
        if (!is_null($durationContract) && !is_numeric($durationContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($durationContract)), __LINE__);
        }
        $this->DurationContract = $durationContract;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\OfferWS
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get bandwidth value
     * @return string|null
     */
    public function getBandwidth()
    {
        return $this->bandwidth;
    }
    /**
     * Set bandwidth value
     * @param string $bandwidth
     * @return \StructType\OfferWS
     */
    public function setBandwidth($bandwidth = null)
    {
        // validation for constraint: string
        if (!is_null($bandwidth) && !is_string($bandwidth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bandwidth)), __LINE__);
        }
        $this->bandwidth = $bandwidth;
        return $this;
    }
    /**
     * Get TypeOfAccess value
     * @return string|null
     */
    public function getTypeOfAccess()
    {
        return $this->TypeOfAccess;
    }
    /**
     * Set TypeOfAccess value
     * @param string $typeOfAccess
     * @return \StructType\OfferWS
     */
    public function setTypeOfAccess($typeOfAccess = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfAccess) && !is_string($typeOfAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeOfAccess)), __LINE__);
        }
        $this->TypeOfAccess = $typeOfAccess;
        return $this;
    }
    /**
     * Get TypeOfZone value
     * @return string|null
     */
    public function getTypeOfZone()
    {
        return $this->TypeOfZone;
    }
    /**
     * Set TypeOfZone value
     * @param string $typeOfZone
     * @return \StructType\OfferWS
     */
    public function setTypeOfZone($typeOfZone = null)
    {
        // validation for constraint: string
        if (!is_null($typeOfZone) && !is_string($typeOfZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($typeOfZone)), __LINE__);
        }
        $this->TypeOfZone = $typeOfZone;
        return $this;
    }
    /**
     * Get CE2OSRHD value
     * @return string|null
     */
    public function getCE2OSRHD()
    {
        return $this->CE2OSRHD;
    }
    /**
     * Set CE2OSRHD value
     * @param string $cE2OSRHD
     * @return \StructType\OfferWS
     */
    public function setCE2OSRHD($cE2OSRHD = null)
    {
        // validation for constraint: string
        if (!is_null($cE2OSRHD) && !is_string($cE2OSRHD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cE2OSRHD)), __LINE__);
        }
        $this->CE2OSRHD = $cE2OSRHD;
        return $this;
    }
    /**
     * Get CELANSRTHD value
     * @return string|null
     */
    public function getCELANSRTHD()
    {
        return $this->CELANSRTHD;
    }
    /**
     * Set CELANSRTHD value
     * @param string $cELANSRTHD
     * @return \StructType\OfferWS
     */
    public function setCELANSRTHD($cELANSRTHD = null)
    {
        // validation for constraint: string
        if (!is_null($cELANSRTHD) && !is_string($cELANSRTHD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cELANSRTHD)), __LINE__);
        }
        $this->CELANSRTHD = $cELANSRTHD;
        return $this;
    }
    /**
     * Get NRCComment value
     * @return string|null
     */
    public function getNRCComment()
    {
        return $this->NRCComment;
    }
    /**
     * Set NRCComment value
     * @param string $nRCComment
     * @return \StructType\OfferWS
     */
    public function setNRCComment($nRCComment = null)
    {
        // validation for constraint: string
        if (!is_null($nRCComment) && !is_string($nRCComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nRCComment)), __LINE__);
        }
        $this->NRCComment = $nRCComment;
        return $this;
    }
    /**
     * Get MRCComment value
     * @return string|null
     */
    public function getMRCComment()
    {
        return $this->MRCComment;
    }
    /**
     * Set MRCComment value
     * @param string $mRCComment
     * @return \StructType\OfferWS
     */
    public function setMRCComment($mRCComment = null)
    {
        // validation for constraint: string
        if (!is_null($mRCComment) && !is_string($mRCComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mRCComment)), __LINE__);
        }
        $this->MRCComment = $mRCComment;
        return $this;
    }
    /**
     * Get Engagement value
     * @return string|null
     */
    public function getEngagement()
    {
        return $this->Engagement;
    }
    /**
     * Set Engagement value
     * @param string $engagement
     * @return \StructType\OfferWS
     */
    public function setEngagement($engagement = null)
    {
        // validation for constraint: string
        if (!is_null($engagement) && !is_string($engagement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($engagement)), __LINE__);
        }
        $this->Engagement = $engagement;
        return $this;
    }
    /**
     * Get TTDComment value
     * @return string|null
     */
    public function getTTDComment()
    {
        return $this->TTDComment;
    }
    /**
     * Set TTDComment value
     * @param string $tTDComment
     * @return \StructType\OfferWS
     */
    public function setTTDComment($tTDComment = null)
    {
        // validation for constraint: string
        if (!is_null($tTDComment) && !is_string($tTDComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tTDComment)), __LINE__);
        }
        $this->TTDComment = $tTDComment;
        return $this;
    }
    /**
     * Get ValidateOfferComment value
     * @return string|null
     */
    public function getValidateOfferComment()
    {
        return $this->ValidateOfferComment;
    }
    /**
     * Set ValidateOfferComment value
     * @param string $validateOfferComment
     * @return \StructType\OfferWS
     */
    public function setValidateOfferComment($validateOfferComment = null)
    {
        // validation for constraint: string
        if (!is_null($validateOfferComment) && !is_string($validateOfferComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validateOfferComment)), __LINE__);
        }
        $this->ValidateOfferComment = $validateOfferComment;
        return $this;
    }
    /**
     * Get RefQuote value
     * @return string|null
     */
    public function getRefQuote()
    {
        return $this->RefQuote;
    }
    /**
     * Set RefQuote value
     * @param string $refQuote
     * @return \StructType\OfferWS
     */
    public function setRefQuote($refQuote = null)
    {
        // validation for constraint: string
        if (!is_null($refQuote) && !is_string($refQuote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refQuote)), __LINE__);
        }
        $this->RefQuote = $refQuote;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OfferWS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
