<?php

namespace Api\Aramex\Location\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Office StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Office
 * @subpackage Structs
 */
class Office extends AbstractStructBase
{
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Entity;
    /**
     * The EntityDescription
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $EntityDescription;
    /**
     * The OfficeType
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $OfficeType;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Address
     */
    public $Address;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Telephone;
    /**
     * The WorkingDays
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WorkingDays;
    /**
     * The WorkingHours
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $WorkingHours;
    /**
     * The Longtitude
     * @var float
     */
    public $Longtitude;
    /**
     * The Latitude
     * @var float
     */
    public $Latitude;
    /**
     * Constructor method for Office
     * @uses Office::setEntity()
     * @uses Office::setEntityDescription()
     * @uses Office::setOfficeType()
     * @uses Office::setAddress()
     * @uses Office::setTelephone()
     * @uses Office::setWorkingDays()
     * @uses Office::setWorkingHours()
     * @uses Office::setLongtitude()
     * @uses Office::setLatitude()
     * @param string $entity
     * @param string $entityDescription
     * @param string $officeType
     * @param \Api\Aramex\Location\StructType\Address $address
     * @param string $telephone
     * @param string $workingDays
     * @param string $workingHours
     * @param float $longtitude
     * @param float $latitude
     */
    public function __construct($entity = null, $entityDescription = null, $officeType = null, \Api\Aramex\Location\StructType\Address $address = null, $telephone = null, $workingDays = null, $workingHours = null, $longtitude = null, $latitude = null)
    {
        $this
            ->setEntity($entity)
            ->setEntityDescription($entityDescription)
            ->setOfficeType($officeType)
            ->setAddress($address)
            ->setTelephone($telephone)
            ->setWorkingDays($workingDays)
            ->setWorkingHours($workingHours)
            ->setLongtitude($longtitude)
            ->setLatitude($latitude);
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get EntityDescription value
     * @return string|null
     */
    public function getEntityDescription()
    {
        return $this->EntityDescription;
    }
    /**
     * Set EntityDescription value
     * @param string $entityDescription
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setEntityDescription($entityDescription = null)
    {
        // validation for constraint: string
        if (!is_null($entityDescription) && !is_string($entityDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entityDescription)), __LINE__);
        }
        $this->EntityDescription = $entityDescription;
        return $this;
    }
    /**
     * Get OfficeType value
     * @return string|null
     */
    public function getOfficeType()
    {
        return $this->OfficeType;
    }
    /**
     * Set OfficeType value
     * @param string $officeType
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setOfficeType($officeType = null)
    {
        // validation for constraint: string
        if (!is_null($officeType) && !is_string($officeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($officeType)), __LINE__);
        }
        $this->OfficeType = $officeType;
        return $this;
    }
    /**
     * Get Address value
     * @return \Api\Aramex\Location\StructType\Address|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Api\Aramex\Location\StructType\Address $address
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setAddress(\Api\Aramex\Location\StructType\Address $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get WorkingDays value
     * @return string|null
     */
    public function getWorkingDays()
    {
        return $this->WorkingDays;
    }
    /**
     * Set WorkingDays value
     * @param string $workingDays
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setWorkingDays($workingDays = null)
    {
        // validation for constraint: string
        if (!is_null($workingDays) && !is_string($workingDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workingDays)), __LINE__);
        }
        $this->WorkingDays = $workingDays;
        return $this;
    }
    /**
     * Get WorkingHours value
     * @return string|null
     */
    public function getWorkingHours()
    {
        return $this->WorkingHours;
    }
    /**
     * Set WorkingHours value
     * @param string $workingHours
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setWorkingHours($workingHours = null)
    {
        // validation for constraint: string
        if (!is_null($workingHours) && !is_string($workingHours)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($workingHours)), __LINE__);
        }
        $this->WorkingHours = $workingHours;
        return $this;
    }
    /**
     * Get Longtitude value
     * @return float|null
     */
    public function getLongtitude()
    {
        return $this->Longtitude;
    }
    /**
     * Set Longtitude value
     * @param float $longtitude
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setLongtitude($longtitude = null)
    {
        $this->Longtitude = $longtitude;
        return $this;
    }
    /**
     * Get Latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->Latitude;
    }
    /**
     * Set Latitude value
     * @param float $latitude
     * @return \Api\Aramex\Location\StructType\Office
     */
    public function setLatitude($latitude = null)
    {
        $this->Latitude = $latitude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\StructType\Office
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
