<?php

namespace Api\Aramex\Location\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Country
 * @subpackage Structs
 */
class Country extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The IsoCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IsoCode;
    /**
     * The StateRequired
     * @var bool
     */
    public $StateRequired;
    /**
     * The PostCodeRequired
     * @var bool
     */
    public $PostCodeRequired;
    /**
     * The PostCodeRegex
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \Api\Aramex\Location\ArrayType\ArrayOfstring
     */
    public $PostCodeRegex;
    /**
     * The InternationalCallingNumber
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $InternationalCallingNumber;
    /**
     * Constructor method for Country
     * @uses Country::setCode()
     * @uses Country::setName()
     * @uses Country::setIsoCode()
     * @uses Country::setStateRequired()
     * @uses Country::setPostCodeRequired()
     * @uses Country::setPostCodeRegex()
     * @uses Country::setInternationalCallingNumber()
     * @param string $code
     * @param string $name
     * @param string $isoCode
     * @param bool $stateRequired
     * @param bool $postCodeRequired
     * @param \Api\Aramex\Location\ArrayType\ArrayOfstring $postCodeRegex
     * @param string $internationalCallingNumber
     */
    public function __construct($code = null, $name = null, $isoCode = null, $stateRequired = null, $postCodeRequired = null, \Api\Aramex\Location\ArrayType\ArrayOfstring $postCodeRegex = null, $internationalCallingNumber = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setIsoCode($isoCode)
            ->setStateRequired($stateRequired)
            ->setPostCodeRequired($postCodeRequired)
            ->setPostCodeRegex($postCodeRegex)
            ->setInternationalCallingNumber($internationalCallingNumber);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IsoCode value
     * @return string|null
     */
    public function getIsoCode()
    {
        return $this->IsoCode;
    }
    /**
     * Set IsoCode value
     * @param string $isoCode
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setIsoCode($isoCode = null)
    {
        // validation for constraint: string
        if (!is_null($isoCode) && !is_string($isoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($isoCode)), __LINE__);
        }
        $this->IsoCode = $isoCode;
        return $this;
    }
    /**
     * Get StateRequired value
     * @return bool|null
     */
    public function getStateRequired()
    {
        return $this->StateRequired;
    }
    /**
     * Set StateRequired value
     * @param bool $stateRequired
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setStateRequired($stateRequired = null)
    {
        $this->StateRequired = $stateRequired;
        return $this;
    }
    /**
     * Get PostCodeRequired value
     * @return bool|null
     */
    public function getPostCodeRequired()
    {
        return $this->PostCodeRequired;
    }
    /**
     * Set PostCodeRequired value
     * @param bool $postCodeRequired
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setPostCodeRequired($postCodeRequired = null)
    {
        $this->PostCodeRequired = $postCodeRequired;
        return $this;
    }
    /**
     * Get PostCodeRegex value
     * @return \Api\Aramex\Location\ArrayType\ArrayOfstring|null
     */
    public function getPostCodeRegex()
    {
        return $this->PostCodeRegex;
    }
    /**
     * Set PostCodeRegex value
     * @param \Api\Aramex\Location\ArrayType\ArrayOfstring $postCodeRegex
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setPostCodeRegex(\Api\Aramex\Location\ArrayType\ArrayOfstring $postCodeRegex = null)
    {
        $this->PostCodeRegex = $postCodeRegex;
        return $this;
    }
    /**
     * Get InternationalCallingNumber value
     * @return string|null
     */
    public function getInternationalCallingNumber()
    {
        return $this->InternationalCallingNumber;
    }
    /**
     * Set InternationalCallingNumber value
     * @param string $internationalCallingNumber
     * @return \Api\Aramex\Location\StructType\Country
     */
    public function setInternationalCallingNumber($internationalCallingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($internationalCallingNumber) && !is_string($internationalCallingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($internationalCallingNumber)), __LINE__);
        }
        $this->InternationalCallingNumber = $internationalCallingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\StructType\Country
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
