<?php

namespace Api\Aramex\Location\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CitiesFetchingRequest StructType
 * @subpackage Structs
 */
class CitiesFetchingRequest extends AbstractStructBase
{
    /**
     * The ClientInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\ClientInfo
     */
    public $ClientInfo;
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Transaction
     */
    public $Transaction;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The NameStartsWith
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameStartsWith;
    /**
     * Constructor method for CitiesFetchingRequest
     * @uses CitiesFetchingRequest::setClientInfo()
     * @uses CitiesFetchingRequest::setTransaction()
     * @uses CitiesFetchingRequest::setCountryCode()
     * @uses CitiesFetchingRequest::setState()
     * @uses CitiesFetchingRequest::setNameStartsWith()
     * @param \Api\Aramex\Location\StructType\ClientInfo $clientInfo
     * @param \Api\Aramex\Location\StructType\Transaction $transaction
     * @param string $countryCode
     * @param string $state
     * @param string $nameStartsWith
     */
    public function __construct(\Api\Aramex\Location\StructType\ClientInfo $clientInfo = null, \Api\Aramex\Location\StructType\Transaction $transaction = null, $countryCode = null, $state = null, $nameStartsWith = null)
    {
        $this
            ->setClientInfo($clientInfo)
            ->setTransaction($transaction)
            ->setCountryCode($countryCode)
            ->setState($state)
            ->setNameStartsWith($nameStartsWith);
    }
    /**
     * Get ClientInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\ClientInfo|null
     */
    public function getClientInfo()
    {
        return isset($this->ClientInfo) ? $this->ClientInfo : null;
    }
    /**
     * Set ClientInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Location\StructType\ClientInfo $clientInfo
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public function setClientInfo(\Api\Aramex\Location\StructType\ClientInfo $clientInfo = null)
    {
        if (is_null($clientInfo) || (is_array($clientInfo) && empty($clientInfo))) {
            unset($this->ClientInfo);
        } else {
            $this->ClientInfo = $clientInfo;
        }
        return $this;
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Location\StructType\Transaction $transaction
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public function setTransaction(\Api\Aramex\Location\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get CountryCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryCode()
    {
        return isset($this->CountryCode) ? $this->CountryCode : null;
    }
    /**
     * Set CountryCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryCode
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        if (is_null($countryCode) || (is_array($countryCode) && empty($countryCode))) {
            unset($this->CountryCode);
        } else {
            $this->CountryCode = $countryCode;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get NameStartsWith value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameStartsWith()
    {
        return isset($this->NameStartsWith) ? $this->NameStartsWith : null;
    }
    /**
     * Set NameStartsWith value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameStartsWith
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public function setNameStartsWith($nameStartsWith = null)
    {
        // validation for constraint: string
        if (!is_null($nameStartsWith) && !is_string($nameStartsWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameStartsWith)), __LINE__);
        }
        if (is_null($nameStartsWith) || (is_array($nameStartsWith) && empty($nameStartsWith))) {
            unset($this->NameStartsWith);
        } else {
            $this->NameStartsWith = $nameStartsWith;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\StructType\CitiesFetchingRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
