<?php

namespace Api\Aramex\Location\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressValidationResponse StructType
 * @subpackage Structs
 */
class AddressValidationResponse extends AbstractStructBase
{
    /**
     * The Transaction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\StructType\Transaction
     */
    public $Transaction;
    /**
     * The Notifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\ArrayType\ArrayOfNotification
     */
    public $Notifications;
    /**
     * The HasErrors
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HasErrors;
    /**
     * The SuggestedAddresses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \Api\Aramex\Location\ArrayType\ArrayOfAddress
     */
    public $SuggestedAddresses;
    /**
     * Constructor method for AddressValidationResponse
     * @uses AddressValidationResponse::setTransaction()
     * @uses AddressValidationResponse::setNotifications()
     * @uses AddressValidationResponse::setHasErrors()
     * @uses AddressValidationResponse::setSuggestedAddresses()
     * @param \Api\Aramex\Location\StructType\Transaction $transaction
     * @param \Api\Aramex\Location\ArrayType\ArrayOfNotification $notifications
     * @param bool $hasErrors
     * @param \Api\Aramex\Location\ArrayType\ArrayOfAddress $suggestedAddresses
     */
    public function __construct(\Api\Aramex\Location\StructType\Transaction $transaction = null, \Api\Aramex\Location\ArrayType\ArrayOfNotification $notifications = null, $hasErrors = null, \Api\Aramex\Location\ArrayType\ArrayOfAddress $suggestedAddresses = null)
    {
        $this
            ->setTransaction($transaction)
            ->setNotifications($notifications)
            ->setHasErrors($hasErrors)
            ->setSuggestedAddresses($suggestedAddresses);
    }
    /**
     * Get Transaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\StructType\Transaction|null
     */
    public function getTransaction()
    {
        return isset($this->Transaction) ? $this->Transaction : null;
    }
    /**
     * Set Transaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Location\StructType\Transaction $transaction
     * @return \Api\Aramex\Location\StructType\AddressValidationResponse
     */
    public function setTransaction(\Api\Aramex\Location\StructType\Transaction $transaction = null)
    {
        if (is_null($transaction) || (is_array($transaction) && empty($transaction))) {
            unset($this->Transaction);
        } else {
            $this->Transaction = $transaction;
        }
        return $this;
    }
    /**
     * Get Notifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\ArrayType\ArrayOfNotification|null
     */
    public function getNotifications()
    {
        return isset($this->Notifications) ? $this->Notifications : null;
    }
    /**
     * Set Notifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Location\ArrayType\ArrayOfNotification $notifications
     * @return \Api\Aramex\Location\StructType\AddressValidationResponse
     */
    public function setNotifications(\Api\Aramex\Location\ArrayType\ArrayOfNotification $notifications = null)
    {
        if (is_null($notifications) || (is_array($notifications) && empty($notifications))) {
            unset($this->Notifications);
        } else {
            $this->Notifications = $notifications;
        }
        return $this;
    }
    /**
     * Get HasErrors value
     * @return bool|null
     */
    public function getHasErrors()
    {
        return $this->HasErrors;
    }
    /**
     * Set HasErrors value
     * @param bool $hasErrors
     * @return \Api\Aramex\Location\StructType\AddressValidationResponse
     */
    public function setHasErrors($hasErrors = null)
    {
        $this->HasErrors = $hasErrors;
        return $this;
    }
    /**
     * Get SuggestedAddresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Api\Aramex\Location\ArrayType\ArrayOfAddress|null
     */
    public function getSuggestedAddresses()
    {
        return isset($this->SuggestedAddresses) ? $this->SuggestedAddresses : null;
    }
    /**
     * Set SuggestedAddresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \Api\Aramex\Location\ArrayType\ArrayOfAddress $suggestedAddresses
     * @return \Api\Aramex\Location\StructType\AddressValidationResponse
     */
    public function setSuggestedAddresses(\Api\Aramex\Location\ArrayType\ArrayOfAddress $suggestedAddresses = null)
    {
        if (is_null($suggestedAddresses) || (is_array($suggestedAddresses) && empty($suggestedAddresses))) {
            unset($this->SuggestedAddresses);
        } else {
            $this->SuggestedAddresses = $suggestedAddresses;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\StructType\AddressValidationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
