<?php

namespace Api\Aramex\Location;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'AddressValidationRequest' => '\\Api\\Aramex\\Location\\StructType\\AddressValidationRequest',
            'ClientInfo' => '\\Api\\Aramex\\Location\\StructType\\ClientInfo',
            'Transaction' => '\\Api\\Aramex\\Location\\StructType\\Transaction',
            'Address' => '\\Api\\Aramex\\Location\\StructType\\Address',
            'AddressValidationResponse' => '\\Api\\Aramex\\Location\\StructType\\AddressValidationResponse',
            'ArrayOfNotification' => '\\Api\\Aramex\\Location\\ArrayType\\ArrayOfNotification',
            'Notification' => '\\Api\\Aramex\\Location\\StructType\\Notification',
            'ArrayOfAddress' => '\\Api\\Aramex\\Location\\ArrayType\\ArrayOfAddress',
            'CountriesFetchingRequest' => '\\Api\\Aramex\\Location\\StructType\\CountriesFetchingRequest',
            'CountriesFetchingResponse' => '\\Api\\Aramex\\Location\\StructType\\CountriesFetchingResponse',
            'ArrayOfCountry' => '\\Api\\Aramex\\Location\\ArrayType\\ArrayOfCountry',
            'Country' => '\\Api\\Aramex\\Location\\StructType\\Country',
            'CountryFetchingRequest' => '\\Api\\Aramex\\Location\\StructType\\CountryFetchingRequest',
            'CountryFetchingResponse' => '\\Api\\Aramex\\Location\\StructType\\CountryFetchingResponse',
            'CitiesFetchingRequest' => '\\Api\\Aramex\\Location\\StructType\\CitiesFetchingRequest',
            'CitiesFetchingResponse' => '\\Api\\Aramex\\Location\\StructType\\CitiesFetchingResponse',
            'OfficesFetchingRequest' => '\\Api\\Aramex\\Location\\StructType\\OfficesFetchingRequest',
            'OfficesFetchingResponse' => '\\Api\\Aramex\\Location\\StructType\\OfficesFetchingResponse',
            'ArrayOfOffice' => '\\Api\\Aramex\\Location\\ArrayType\\ArrayOfOffice',
            'Office' => '\\Api\\Aramex\\Location\\StructType\\Office',
            'ArrayOfstring' => '\\Api\\Aramex\\Location\\ArrayType\\ArrayOfstring',
        );
    }
}
