<?php

namespace Api\Aramex\Location\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The Line1
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Line1;
    /**
     * The Line2
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Line2;
    /**
     * The Line3
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Line3;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The StateOrProvinceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateOrProvinceCode;
    /**
     * The PostCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $PostCode;
    /**
     * The CountryCode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for Address
     * @uses Address::setLine1()
     * @uses Address::setLine2()
     * @uses Address::setLine3()
     * @uses Address::setCity()
     * @uses Address::setStateOrProvinceCode()
     * @uses Address::setPostCode()
     * @uses Address::setCountryCode()
     * @param string $line1
     * @param string $line2
     * @param string $line3
     * @param string $city
     * @param string $stateOrProvinceCode
     * @param string $postCode
     * @param string $countryCode
     */
    public function __construct($line1 = null, $line2 = null, $line3 = null, $city = null, $stateOrProvinceCode = null, $postCode = null, $countryCode = null)
    {
        $this
            ->setLine1($line1)
            ->setLine2($line2)
            ->setLine3($line3)
            ->setCity($city)
            ->setStateOrProvinceCode($stateOrProvinceCode)
            ->setPostCode($postCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get Line1 value
     * @return string|null
     */
    public function getLine1()
    {
        return $this->Line1;
    }
    /**
     * Set Line1 value
     * @param string $line1
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setLine1($line1 = null)
    {
        // validation for constraint: string
        if (!is_null($line1) && !is_string($line1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line1)), __LINE__);
        }
        $this->Line1 = $line1;
        return $this;
    }
    /**
     * Get Line2 value
     * @return string|null
     */
    public function getLine2()
    {
        return $this->Line2;
    }
    /**
     * Set Line2 value
     * @param string $line2
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setLine2($line2 = null)
    {
        // validation for constraint: string
        if (!is_null($line2) && !is_string($line2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line2)), __LINE__);
        }
        $this->Line2 = $line2;
        return $this;
    }
    /**
     * Get Line3 value
     * @return string|null
     */
    public function getLine3()
    {
        return $this->Line3;
    }
    /**
     * Set Line3 value
     * @param string $line3
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setLine3($line3 = null)
    {
        // validation for constraint: string
        if (!is_null($line3) && !is_string($line3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($line3)), __LINE__);
        }
        $this->Line3 = $line3;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get StateOrProvinceCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateOrProvinceCode()
    {
        return isset($this->StateOrProvinceCode) ? $this->StateOrProvinceCode : null;
    }
    /**
     * Set StateOrProvinceCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateOrProvinceCode
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setStateOrProvinceCode($stateOrProvinceCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateOrProvinceCode) && !is_string($stateOrProvinceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateOrProvinceCode)), __LINE__);
        }
        if (is_null($stateOrProvinceCode) || (is_array($stateOrProvinceCode) && empty($stateOrProvinceCode))) {
            unset($this->StateOrProvinceCode);
        } else {
            $this->StateOrProvinceCode = $stateOrProvinceCode;
        }
        return $this;
    }
    /**
     * Get PostCode value
     * @return string|null
     */
    public function getPostCode()
    {
        return $this->PostCode;
    }
    /**
     * Set PostCode value
     * @param string $postCode
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setPostCode($postCode = null)
    {
        // validation for constraint: string
        if (!is_null($postCode) && !is_string($postCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postCode)), __LINE__);
        }
        $this->PostCode = $postCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \Api\Aramex\Location\StructType\Address
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Api\Aramex\Location\StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
