<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \Api\Aramex\Location\ClassMap::get(),
);
/**
 * Samples for Validate ServiceType
 */
$validate = new \Api\Aramex\Location\ServiceType\Validate($options);
/**
 * Sample call for ValidateAddress operation/method
 */
if ($validate->ValidateAddress(new \Api\Aramex\Location\StructType\AddressValidationRequest()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Fetch ServiceType
 */
$fetch = new \Api\Aramex\Location\ServiceType\Fetch($options);
/**
 * Sample call for FetchCountries operation/method
 */
if ($fetch->FetchCountries(new \Api\Aramex\Location\StructType\CountriesFetchingRequest()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for FetchCountry operation/method
 */
if ($fetch->FetchCountry(new \Api\Aramex\Location\StructType\CountryFetchingRequest()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for FetchCities operation/method
 */
if ($fetch->FetchCities(new \Api\Aramex\Location\StructType\CitiesFetchingRequest()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
/**
 * Sample call for FetchOffices operation/method
 */
if ($fetch->FetchOffices(new \Api\Aramex\Location\StructType\OfficesFetchingRequest()) !== false) {
    print_r($fetch->getResult());
} else {
    print_r($fetch->getLastError());
}
